program SortTest;

{This program will compare 6 sorting algorithms:
 Bubble Sort,
 Selection Sort
 Insertion Sort,
 Shell Sort,
 Merge Sort
 and Quick Sort.

 The comparisons will include # of assignments, # of comparisons, and
 total running time.

}

uses SortUnit, CRT, DOS;

const
  MaxNumInts = 1000;


var
  Data,
  Secondary  : DatArray;
  StartClock : real;
  NumItems   : integer;

function ClockOn : real;

var
  hr,
  min,
  sec,
  hs   : word;

begin
  GetTime(hr, min, sec, hs);
  ClockOn := hr*3600 + min*60 + sec + hs/100;
end;

function ClockOff(StartVal : real) : real;

var
  hr,
  min,
  sec,
  hs   : word;
  Temp : real;

begin
  GetTime(hr, min, sec, hs);
  ClockOff := hr*3600 + min*60 + sec + hs/100 - StartVal;
end;


procedure Build_List(Var table : DatArray; N : integer);

{ Builds an array of N integers, from the random number generator
  in Turbo Pascal. A small delay is added to insure that the
  numbers are more random on faster machines. (20 MHZ +)           }

var
  X: integer;

begin
  randomize;
  writeln('                            Building Table:');
  for X:= 1 to N do
    begin
      { The delay here is to provide more random values for faster CPUs. }
      delay(1);
      gotoxy(45,1);
      write(x:4);
      Table[X] := random(1000);
    end;
end;

procedure Set_Up(var Table : DatArray; var NumItems : integer);

{ Get the number of items the user wants to sort, and build
  the table of random numbers...                              }

begin
  clrscr;
  gotoxy(20,12);
  write('How many numbers to sort? ');
  readln(NumItems);
  clrscr;
  Build_List(Table, NumItems);
end;


procedure DisplayTable(Table : DatArray; NumItems : integer);

{ Display the un-sorted table for the user. }

var
  X : integer;

begin
  writeln;
  writeln;
  for X:= 1 to NumItems do
    begin
      write(Table[X]:6);
      if X mod 12 = 0 then writeln;
    end;
    writeln;
end;



begin
  { Set everything up. }
  Set_Up(Secondary, NumItems);

  { Display the table and wait for the user to continue.}
  DisplayTable(Secondary, NumItems);
  writeln;
  writeln('                         Press Enter to Continue');
  readln;

  { Ok, Time to start sorting. Set the screen up first. }
  clrscr;
  Data := Secondary;
  writeln(' Sort Routine       Time      ');
  writeln('---------------+--------------');

  { Ok, starting with the random order list, run each sort }
  { ---> Bubble Sort }
  StartClock := ClockOn;
  Bubble_Sort(Data, NumItems);
  writeln('Bubble         : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Selection Sort }
  StartClock := ClockOn;
  Select_Sort(Data, NumItems);
  writeln('Selection      : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Insertion Sort }
  StartClock := ClockOn;
  Insert_Sort(Data, NumItems);
  writeln('Insertion Sort : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Shell Sort }
  StartClock := ClockOn;
  Shell_Sort(Data, NumItems);
  writeln('Shell Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Merge Sort }
  StartClock := ClockOn;
  Merge_Sort(Data, 1, NumItems);
  writeln('Merge Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;


  { Because the QuickSort requires so much memory, it should be handled
    seperately from all the other sorts.
  }
  { ---> Quick Sort }
{  StartClock := ClockOn;
  Quick_Sort(Data, 1, NumItems);
  writeln('Quick Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |');
}
  { Ok, now the list of ordered data! }
  Writeln('-----------------> Pre-Sorted Data <---------------');

  { ---> Bubble Sort }
  StartClock := ClockOn;
  Bubble_Sort(Data, NumItems);
  writeln('Bubble         : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Selection Sort }
  StartClock := ClockOn;
  Select_Sort(Data, NumItems);
  writeln('Selection      : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Insertion Sort }
  StartClock := ClockOn;
  Insert_Sort(Data, NumItems);
  writeln('Insertion Sort : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Shell Sort }
  StartClock := ClockOn;
  Shell_Sort(Data, NumItems);
  writeln('Shell Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { ---> Merge Sort }
  StartClock := ClockOn;
  Merge_Sort(Data, 1, NumItems);
  writeln('Merge Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |');
  Data := Secondary;

  { Because the QuickSort requires so much memory, it should be handled
    seperately from all the other sorts.
  }
  { ---> Quick Sort }
{  StartClock := ClockOn;
  Quick_Sort(Data, 1, NumItems);
  writeln('Quick Sort     : ', ClockOff(StartClock):5:2, ' Secs.  |'); }
end.