/*----------------------------------------------------------
   MACDEMO.C -- OS/2 Keyboard Macro Demonstration
                (C) 1988, Ziff-Davis Communications Company
                Programmed by Charles Petzold, 11/87
  ----------------------------------------------------------*/

#include <doscalls.h>
#include <subcalls.h>
#include <string.h>

main ()
     {
     static struct  {
                    char scan ;
                    char *str ;
                    }
                    table [] = {
                               0x20, "DIR\r",
                               0x2E, "CHKDSK\r",
                               0x2F, "VER\r"
                               } ;
     struct MonKeyData 
                    {
                    unsigned int   MonFlagWord ;
                    struct KeyData kd ;
                    unsigned int   KbdDDFlagWord ;
                    }
                    mkd ;

     char           InBuffer [128], OutBuffer [128] ;
     unsigned int   GlobalSeg, LocalSeg, ScreenGroup, MonitorHandle ;
     unsigned int   count, len, i, j ;

     DOSMONOPEN ("KBD$", &MonitorHandle) ;

     * (int *) InBuffer  = sizeof (InBuffer) ;
     * (int *) OutBuffer = sizeof (OutBuffer) ;

     DOSGETINFOSEG (&GlobalSeg, &LocalSeg) ;

     ScreenGroup = * ((unsigned char far *) (((long) GlobalSeg << 16) + 24)) ;

     DOSMONREG (MonitorHandle, InBuffer, OutBuffer, 0, ScreenGroup) ;

     while (1)
          {
          count = sizeof (mkd) ;

          DOSMONREAD (InBuffer, 0, (char far *) &mkd, &count) ;

          if (mkd.kd.char_code == 0 && mkd.KbdDDFlagWord == 0)
               {                              for (i = 0 ; i < sizeof (table) / sizeof (table [0]) ; i++)
                    {
                    if (mkd.kd.scan_code == table[i].scan)
                         {
                         len = strlen (table[i].str) ;

                         mkd.MonFlagWord = 0 ;
                         mkd.kd.scan_code = 0 ;
                         mkd.kd.status = 0 ;
                         mkd.kd.nls_shift = 0 ;
                         mkd.kd.shift_state = 0 ;

                         for (j = 0 ; j < len ; j++)
                              {
                              mkd.kd.char_code = table[i].str[j] ;

                              DOSMONWRITE (OutBuffer, (char far *) &mkd,
                                           sizeof (mkd)) ;
                              }
                         break ;
                         }
                    }
               }
          else
               DOSMONWRITE (OutBuffer, (char far *) &mkd, count) ;
          }
     }
