        name    tryitoa
        title   TRYITOA
        page    55,132

;
; TRYITOA.ASM --- a simple demonstration of
;                 the ITOA and ATOI routines.
;
; Ray Duncan, October 1987
;

cr      equ     0dh
lf      equ     0ah


DGROUP  group   _DATA


_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   itoa:near
        extrn   atoi:near

main    proc    near

        mov     ax,_DATA                ; make our data segment
        mov     ds,ax                   ; addressable...
        mov     es,ax
        
main1:  mov     dx,offset prompt        ; display a prompt
        mov     cx,p_len                ; to the user...
        mov     bx,1                    ; "Enter value: " 
        mov     ah,40h
        int     21h
        jc      main2                   ; if error, just exit

        mov     dx,offset inbuff        ; read keyboard entry
        mov     cx,80                   ; from the user...
        mov     bx,0
        mov     ah,3fh
        int     21h
        jc      main2                   ; if error, just exit

        cmp     ax,2                    ; did he enter anything?
        je      main2                   ; empty line, exit

        mov     dx,offset display       ; display "You entered: "
        mov     cx,d_len                ; to the user...
        mov     bx,1
        mov     ah,40h
        int     21h
        jc      main2                   ; if error, just exit
        
        mov     si,offset inbuff        ; convert convert user's 
        call    atoi                    ; input to binary in AX
                                        
        mov     cx,10                   ; convert value in AX back 
        mov     si,offset outbuff       ; to ASCII string for output
        call    itoa

        mov     cx,ax                   ; CX = string length
        mov     dx,si                   ; DS:DX = string address 
        mov     bx,1                    ; now display converted
        mov     ah,40h                  ; ASCII string...
        int     21h                     ; 
        jc      main2                   ; if error, just exit

        jmp     main1                   ; do it again...


main2:  mov     ax,4c00h                ; final exit to MS-DOS
        int     21h

main    endp

_TEXT   ends


_DATA   segment word public 'DATA'

prompt  db      cr,lf,lf,'Enter a number: '
p_len   equ     $-prompt

display db      cr,lf,lf,'You entered:',4 dup(32)
d_len   equ     $-display

inbuff  db      80 dup (?)

outbuff db      80 dup (?)

_DATA   ends



STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends


        end     main
