
/*
    HELLOPMW.C  ---  "Hello Protected Mode World!"
    Illustrates use of the DPMI interface to switch into
    protected mode, and use of Windows 3's built-in DOS
    Extender to print a message in protected mode.

    Compile in SMALL MODEL with:  CL HELLOPMW.C

    Execute under Windows 3.0 only!
*/

#include <stdio.h>
 
unsigned modeswitch();

main() 
{
    unsigned saveCS, saveDS;

    _asm mov saveCS,cs          ; store real mode CS 
    _asm mov saveDS,ds          ; and DS for display

    printf("\nHello, real mode world! \tCS=%04xh DS=%04xh", 
        saveCS, saveDS);

    if(modeswitch())            // attempt mode switch
    {
        puts("\nDPMI not available or memory allocation failed.");
        exit(1);
    }

    _asm mov saveCS,cs          ; store protected mode CS
    _asm mov saveDS,ds          ; and DS for display
 
    printf("\nHello, protected mode world! \tCS=%04xh DS=%04xh\n", 
        saveCS, saveDS);

    _asm mov ah,4ch             ; exit directly to DOS to avoid
    _asm int 21h                ; GP fault in RTL cleanup code
}

/*
    Call DPMI to switch from real mode to protected mode.
    Returns false if mode switch successful, true if no DPMI 
    present or if memory allocation for DPMI data area failed.
*/
unsigned modeswitch(void)
{
    void far *switchpoint;              // far pointer to DPMI
                                        // mode switch entry point
    _asm
    {
        mov     ax,1687h                ; get DPMI mode switch
        int     2fh                     ; entry point...
        or      ax,ax                   ; bail out if no DPMI
        jnz     exitlabel
        mov     word ptr switchpoint,di ; save entry point
        mov     word ptr switchpoint+2,es
        mov     bx,si                   ; allocate DPMI private
        mov     ah,48h                  ; data area
        int     21h
        jc      exitlabel               ; jump, allocation failed
        mov     es,ax                   ; pass segment of data area     
        mov     ax,0                    ; indicate we are 16-bit app
        call    switchpoint             ; switch to protected mode
        mov     ax,0                    ; signal success
    }

    exitlabel: ;                        // any "no return value" warning 
}                                       // message here can be ignored

