***********************************************************************
* CALDEMO.PRG
* Demonstrate usage of PopDate
***********************************************************************
SET ECHO OFF
SET TALK OFF
SET SYSMENU OFF

DO BackDrop                          && Background for demo purposes
DO Inquiry                           && Sample date field usage with
                                     && pop-up calendar
RELEASE ALL
CLEAR ALL
RETURN

***********************************************************************
* PROCEDURE Inquiry
* Demonstrate use of PopDate, which is called from PopCal
***********************************************************************
PROCEDURE Inquiry
DEFINE WINDOW Inquiry FROM  5,13 TO 15,67 ;
COLOR G+/B,N/W,BG+/B TITLE 'Inquiry'
ACTIVATE WINDOW Inquiry

@ 1, 8 SAY "Destination:"
@ 3, 2 SAY "Date of Departure:"
@ 4, 5 SAY "Date of Return:"
@ 6, 5 SAY "Number of days:"

STORE SPACE(25) TO m->dest
STORE DATE() TO m->depdate
STORE DATE()+1 TO m->retdate

ON KEY LABEL F2 DO PopCal            && F2 activates PopCal

DO WHILE .T.
   SET COLOR TO ,N/W
   @ 1,21 GET m->dest PICTURE "@M Hawaii, Florida, Italy" ;
   MESSAGE WinMsg("Enter destination, press spacebar to cycle choices")

   @ 3,21 GET m->depdate ;
   MESSAGE WinMsg("Enter Departure date, press F2 for calendar") ;
   VALID DateCheck(1, m->depdate, m->retdate) ;
   ERROR "Invalid departure date, please reenter"

   @ 4,21 GET m->retdate ;
   MESSAGE WinMsg("Enter Return date, press F2 for calendar") ;
   VALID DateCheck(2, m->depdate, m->retdate) ;
   ERROR "Invalid return date, please reenter"

   READ
   SET COLOR TO G+/B
   @ 6,21 SAY (m->retdate - m->depdate)+1 PICTURE [999]
   IF READKEY()==268 .OR. READKEY()==12   && Escape cancels
      EXIT
   ENDIF
ENDDO

ON KEY LABEL F2                      && Restore F2
RELEASE WINDOW Inquiry
RETURN

******************************************************************
* PROCEDURE PopCal
*
* Calls POPDATE.  Only allows pop-up if user is currently
* editing the departure date or return date fields
******************************************************************
PROCEDURE POPCAL
PRIVATE var
var = VARREAD()                      && Find out what field we're in
DO CASE
 CASE var == "DEPDATE" .OR. ;
   var == "RETDATE"                  && If it is the departure date
                                     && or return date fields
   IF EMPTY(&var)                    && If it is empty don't set
      &var = POPDATE(2,51)           && the default in the calendar
   ELSE                              && otherwise pop-up the calendar
      &var = POPDATE(2,51,&var)      && with that date highlighted
   ENDIF
 OTHERWISE
ENDCASE
RETURN

*******************************************************************
* FUNCTION WinMsg
*
* Display a centered message on the last line of the active
* window.  For use with the MESSAGE option on @...GET.
*******************************************************************
FUNCTION WinMsg
PARAMETER TEXT
@ WROWS()-1, 0 SAY PADC(TEXT,WCOLS())
RETURN ""

*******************************************************************
* FUNCTION DateCheck
* Simple validation for departure and return dates
*******************************************************************
FUNCTION DateCheck
PARAMETERS dnum, ddate, rdate

DO CASE
 CASE dnum == 1                      && Validating the departure date
   *
   * --- Can't be before today or empty
   *
   IF ddate < DATE() .OR. EMPTY(ddate)
      RETURN .F.
   ENDIF
 CASE dnum == 2                      && Validating the return date
   *
   * --- Can't be before departure date or empty
   *
   IF rdate < ddate .OR. EMPTY(rdate)
      RETURN .F.
   ENDIF
 OTHERWISE
ENDCASE
RETURN .T.

***********************************************************************
* PROCEDURE BackDrop
* Put some background on the screen for demo purposes
***********************************************************************
PROCEDURE BackDrop
DEFINE WINDOW BackDrop FROM  3, 1 TO 17,79 ;
COLOR G+/B,N/W,BG+/B TITLE 'XYZ Travel Agency'
ACTIVATE WINDOW BackDrop
@ 1, 3 SAY "Prefix: Mr. and Mrs."
@ 2, 5 SAY "Last: Doe"
@ 3, 4 SAY "First: John"
@ 4, 3 SAY "Middle: J."
@ 5, 3 SAY "Suffix: Sr."
@ 7, 2 SAY "Address: 27 Pine Lane"
@ 8, 9 SAY ": Suite 21A"
@ 9, 9 SAY ":"
@10, 5 SAY "City: Anytown"
@11, 4 SAY "State: PA  Zip: 12345"
RETURN

***********************************************************************
*   Name: POPDATE.PRG
* Author: Andrew Coupe
*  Usage: <expD>=POPDATE(<row>,<col>,[<default>])
*  Notes: UDF to popup a date selection box in FoxPRO 1.02
***********************************************************************
FUNCTION POPDATE
PARAMETER row,col,DEFAULT

thismsg = SET("MESSAGE",1)            && Record current message line
thisdate =_diarydate                  && Save original date
*
* --- If default date is passed, use it, else use _dairydate
*
DEFAULT = IIF( PARAMETERS()=3, DEFAULT, _diarydate)
_diarydate = DEFAULT

DEFINE WINDOW CAL FROM row,col TO row+16,col+22 ;
DOUBLE TITLE "[CALENDAR]"
*
* --- Need SET STATUS ON to see the following message
*
SET MESSAGE TO ;
"Change date with arrow keys. [T]oday, Month:[PgUp/PgDn] Year:[^PgUp/^PgDn]"

ACTIVATE WINDOW cal

ACTIVATE WINDOW calendar IN cal

MOVE WINDOW calendar TO -1,-1        && Center calendar in window

DO WHILE LASTKEY() # 27              && While ESCAPE not HIT

   i=INKEY(0,"H")                    && Get keystroke

   DO CASE
    CASE i=13 .OR. i==27             && Enter or Esc
      EXIT

    CASE i=84.OR. i=116              && 'T' for Today
      _diarydate=DATE()

    CASE i =24                       && Down arrow
      _diarydate=_diarydate+7

    CASE i= 5                        && Up arrow
      _diarydate=_diarydate-7

    CASE i=19                        && Left arrow
      _diarydate=_diarydate-1

    CASE i=4                         && Right arrow
      _diarydate=_diarydate+1

    CASE i=3                         && Page down
      _diarydate=gomonth(_diarydate,1)

    CASE i=18                        && Page up
      _diarydate=gomonth(_diarydate,-1)

    CASE I= 30                       && ^Page down
      _diarydate=gomonth(_diarydate,12)

    CASE I= 31                       && ^Page Up
      _diarydate=gomonth(_diarydate,-12)
   ENDCASE
ENDDO

SET MESSAGE TO (thismsg)             && Restore message
RELEASE WINDOWS cal                  && Release CAL windows
*
* --- Return default date in ESC was pressed
*     otherwise return the selected date
*
newdate = ;
IIF( LASTKEY()=27, default, _diarydate)

_diarydate = thisdate                && Set system variable back

RETURN newdate                       && Return the selected date


