***********************************************************************
* PINVOICE.PRG                             for FoxPro 1.02
* Sample program to demonstrate use of the atsay function.
***********************************************************************
uon   = CHR(27)+"&d0D"           && Turn on underline
uoff  = CHR(27)+"&d0@"           && Turn off underline
=ljsetup()                       && Reset Laserjet

=helv(12)                        && Select Helvetica 12pt.

USE pinv
=atsay(2, 1, "Custno: ")
=atsay(2, 9, custno)
=atsay(2, 35, "Item")
=atsay(3, 35, uon+" No. "+uoff)
=atsay(3, 41, uon+"Qty.  "+uoff)
=atsay(3, 47, uon+"Cost       "+uoff)
=atsay(3, 56, uon+"Total        "+uoff)

=helvi(12)                       && Select Helv 12pt. Italic

=atsay(5, 1, "This is an example of lining up numeric")
=atsay(6, 1, "output using a proportional font on an")
=atsay(7, 1, "HP Laserjet Series printer.")
=atsay(10, 1, "Payment is overdue.")
=atsay(0, 25, "I N V O I C E    D E T A I L S")

=helv(12)                        && Select Helvetica 12pt.

m.custno = custno
m.row = 5                        && Start with line 5
gtotal = 0                       && Print details
DO WHILE m.custno = custno
  =atsay(m.row, 35, itemno)
  =atsay(m.row, 41, qty, "999")
  =atsay(m.row, 45, cost, "9,999.99")
  =atsay(m.row, 53, cost*qty, "999,999.99")
  gtotal = gtotal + (cost*qty)
  m.row = m.row + 1
  SKIP
ENDDO
m.row = m.row + 2
=atsay(m.row, 28, "Total:")
=atsay(m.row, 51, gtotal, "$,$$$,999.99")
EJECT
=ljsetup()                       && Reset Laserjet
USE
RETURN

FUNCTION ljsetup
??? CHR(27) + "E"                && Resets Laserjet to front panel defaults
RELEASE lpi, pitch
PUBLIC lpi, pitch
lpi = 6                          && Set up lines per inch
pitch = 10                       && Set up pitch (characters per inch)
RETURN ""

FUNCTION helv
PARAMETERS point
??? CHR(27) + "&l0O" + CHR(27) + "(0U" + CHR(27) + "(s1p" + ;
  LTRIM(STR(point,5,2)) + "v0s0b4T"
RETURN

FUNCTION helvi
PARAMETERS point
??? CHR(27) + "&l0O" + CHR(27) + "(0U" + CHR(27) + "(s1p" + ;
  LTRIM(STR(point,5,2)) + "v1s0b4T"
RETURN


***********************************************************************
* FUNCTION atsay
*
* Use HP LJ vertical and horizontal decipoint positioning to place
* character or numeric output on a page.
*
* Requires PUBLIC variables pitch and lpi.
*
***********************************************************************
FUNCTION atsay
PARAMETERS mrow, mcol, fieldval, pictval

move_hor = ROUND(720/pitch, 2)         && Relative horizontal move value
hor = 720/pitch * mcol                 && Horizontal position based on @ SAY value
ver = LTRIM(STR(720/lpi * mrow, 5, 2)) && Vertical position based on @ SAY value

IF TYPE("pictval") = "C"               && "L" if not provided
   fieldval = TRANSFORM(fieldval, pictval)   && Transform the number
   no_chars = LEN(fieldval)            && Calculate length of field
   ??? CHR(27) + "&a" + LTRIM(STR(hor,5,2)) + "h" + ver + "V"
   *
   * Calculate rightmost character position
   *
   end_hor = hor + (move_hor * no_chars)
   *
   * Calculate leftmost character position allowing 90% of pitch value
   * for each character
   new_pos = end_hor - (move_hor * no_chars * .9)
   FOR char = 1 TO no_chars
      ??? CHR(27) + "&a" + LTRIM(STR(new_pos,5,2)) + "H" + SUBSTR(fieldval,char,1)
      new_pos = new_pos + (move_hor * .9)       && Calculate next character position
   ENDFOR
ELSE
   ??? CHR(27) + "&a" + LTRIM(STR(hor,5,2)) + "h" +  ver + "V" + fieldval
ENDIF
RETURN ""
