/*---------------------------------------------------------
   RECORD2.C -- Multimedia Windows Waveform Audio Recorder
                (c) Charles Petzold, 1991
  ---------------------------------------------------------*/

#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "record2.h"

BOOL FAR PASCAL DlgProc (HWND, WORD, WORD, LONG) ;

static char szAppName [] = "Record2" ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     FARPROC lpDlgProc ;

     lpDlgProc = MakeProcInstance (DlgProc, hInstance) ;
     DialogBox (hInstance, szAppName, NULL, lpDlgProc) ;
     FreeProcInstance (lpDlgProc) ;

     return 0 ;
     }

void ShowError (HWND hwnd, DWORD dwError)
     {
     static char szErrorStr [80] ;

     mciGetErrorString (dwError, szErrorStr, 80) ;
     MessageBeep (MB_ICONEXCLAMATION) ;
     MessageBox (hwnd, szErrorStr, szAppName, MB_OK | MB_ICONEXCLAMATION) ;
     }

BOOL FAR PASCAL DlgProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static BOOL            bRecording, bPlaying, bPaused ;
     static char            szFileName[] = "record2.wav" ;
     static WORD            wDeviceID ;
     DWORD                  dwError ;
     MCI_GENERIC_PARMS      mciGeneric ;
     MCI_OPEN_PARMS         mciOpen ;
     MCI_PLAY_PARMS         mciPlay ;
     MCI_WAVE_RECORD_PARMS  mciRecord ;

     switch (message)
          {
          case WM_COMMAND:
               switch (wParam)
                    {
                    case ID_RECORD_BEG:
                                        // Delete Existing Waveform File

                         remove (szFileName) ;

                                        // Open Waveform Audio

                         mciOpen.dwCallback       = 0L ;
                         mciOpen.wDeviceID        = 0 ;
                         mciOpen.wReserved0       = 0 ;
                         mciOpen.lpstrDeviceType  = NULL ;
                         mciOpen.lpstrElementName = szFileName ;
                         mciOpen.lpstrAlias       = NULL ;

                         dwError = mciSendCommand (0, MCI_OPEN,
                                        MCI_WAIT | MCI_OPEN_ELEMENT,
                                        (DWORD) (LPMCI_OPEN_PARMS) &mciOpen) ;

                         if (dwError != 0L)
                              {
                              ShowError (hwnd, dwError) ;
                              return TRUE ;
                              }
                                        // Save the Device ID

                         wDeviceID = mciOpen.wDeviceID ;

                                        // Begin Recording

                         mciRecord.dwCallback = hwnd ;
                         mciRecord.dwFrom     = 0 ;
                         mciRecord.dwTo       = 0 ;

                         mciSendCommand (wDeviceID, MCI_RECORD, MCI_NOTIFY,
                              (DWORD) (LPMCI_WAVE_RECORD_PARMS) &mciRecord) ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_RECORD_END)) ;

                         bRecording = TRUE ;
                         return TRUE ;

                    case ID_RECORD_END:
                                        // Stop Recording

                         mciGeneric.dwCallback = 0L ;

                         mciSendCommand (wDeviceID, MCI_STOP, MCI_WAIT,
                              (DWORD) (LPMCI_GENERIC_PARMS) &mciGeneric) ;

                                        // Save the File

                         mciSendCommand (wDeviceID, MCI_SAVE, MCI_WAIT,
                              (DWORD) (LPMCI_GENERIC_PARMS) &mciGeneric) ;

                                        // Close the Waveform Device

                         mciSendCommand (wDeviceID, MCI_CLOSE, MCI_WAIT,
                              (DWORD) (LPMCI_GENERIC_PARMS) &mciGeneric) ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_BEG)) ;

                         bRecording = FALSE ;
                         return TRUE ;

                    case ID_PLAY_BEG:
                                        // Open Waveform Audio

                         mciOpen.dwCallback       = 0L ;
                         mciOpen.wDeviceID        = 0 ;
                         mciOpen.wReserved0       = 0 ;
                         mciOpen.lpstrDeviceType  = NULL ;
                         mciOpen.lpstrElementName = szFileName ;
                         mciOpen.lpstrAlias       = NULL ;

                         dwError = mciSendCommand (0, MCI_OPEN,
                                        MCI_WAIT | MCI_OPEN_ELEMENT,
                                        (DWORD) (LPMCI_OPEN_PARMS) &mciOpen) ;

                         if (dwError != 0L)
                              {
                              ShowError (hwnd, dwError) ;
                              return TRUE ;
                              }
                                        // Save the Device ID

                         wDeviceID = mciOpen.wDeviceID ;

                                        // Begin Playing

                         mciPlay.dwCallback = hwnd ;
                         mciPlay.dwFrom     = 0 ;
                         mciPlay.dwTo       = 0 ;

                         mciSendCommand (wDeviceID, MCI_PLAY, MCI_NOTIFY,
                             (DWORD) (LPMCI_PLAY_PARMS) &mciPlay) ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   TRUE) ;
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_END)) ;

                         bPlaying = TRUE ;
                         return TRUE ;

                    case ID_PLAY_PAUSE:
                         if (!bPaused)
                                        // Pause the Play
                              {
                              mciGeneric.dwCallback = 0L ;

                              mciSendCommand (wDeviceID, MCI_PAUSE, MCI_WAIT,
                                   (DWORD) (LPMCI_GENERIC_PARMS) & mciGeneric);

                              SetDlgItemText (hwnd, ID_PLAY_PAUSE, "Resume") ;
                              bPaused = TRUE ;
                              }
                         else
                                        // Begin Playing Again
                              {
                              mciPlay.dwCallback = hwnd ;
                              mciPlay.dwFrom     = 0 ;
                              mciPlay.dwTo       = 0 ;

                              mciSendCommand (wDeviceID, MCI_PLAY, MCI_NOTIFY,
                                  (DWORD) (LPMCI_PLAY_PARMS) &mciPlay) ;

                              SetDlgItemText (hwnd, ID_PLAY_PAUSE, "Pause") ;
                              bPaused = FALSE ;
                              }

                         return TRUE ;

                    case ID_PLAY_END:
                                        // Stop and Close

                         mciGeneric.dwCallback = 0L ;

                         mciSendCommand (wDeviceID, MCI_STOP, MCI_WAIT,
                              (DWORD) (LPMCI_GENERIC_PARMS) &mciGeneric) ;

                         mciSendCommand (wDeviceID, MCI_CLOSE, MCI_WAIT,
                              (DWORD) (LPMCI_GENERIC_PARMS) &mciGeneric) ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_BEG)) ;

                         bPlaying = FALSE ;
                         bPaused  = FALSE ;
                         return TRUE ;
                    }
               break ;

          case MM_MCINOTIFY:
               switch (wParam)
                    {
                    case MCI_NOTIFY_SUCCESSFUL:
                         if (bPlaying)
                              SendMessage (hwnd, WM_COMMAND, ID_PLAY_END, 0L) ;

                         if (bRecording)
                              SendMessage (hwnd, WM_COMMAND, ID_RECORD_END, 0L);

                         return TRUE ;
                    }
               break ;

          case WM_SYSCOMMAND:
               switch (wParam)
                    {
                    case SC_CLOSE:
                         if (bRecording)
                              SendMessage (hwnd, WM_COMMAND, ID_RECORD_END, 0L) ;

                         if (bPlaying)
                              SendMessage (hwnd, WM_COMMAND, ID_PLAY_END, 0L) ;

                         EndDialog (hwnd, 0) ;
                         return TRUE ;
                    }
               break ;
          }
     return FALSE ;
     }
