// chkdupe.cpp

#include<stdio.h>
#include<string.h>
#include<stdlib.h>

#pragma hdrstop
#include"finddupe.h"
#include"chkdupe.h"
#include"msgbox.h"

extern unsigned _stklen = 8192;

ChkDupe::ChkDupe(void)
    {
    if(GetSwitchArg('?'))
        terminate();

        // create settings object and initialize
    Settings.SetName("SHOWDUPE.INI");

    for(int i = 0; i < NUMSETTINGS; i++)
        Settings.AddLine(MySettings[i].name,MySettings[i].value);

    // open .INI file here and override settings
    Settings.Read();

    if(!FilesExist())
        if(GetArgCount() == 0)
            {
            char searchdirs[200];
            if(!strlen(Settings.GetLine(MySettings[SEARCHDIRS].name,
                    searchdirs)))
                terminate();
            }

    InitApp();   
    
    ShowDupes();
    }

static char *colorstrings[16] = 
    {   
    "BLACK", "BLUE", "GREEN", "CYAN", 
    "RED", "MAGENTA", "BROWN", "LIGHTGRAY",
    "DARKGRAY", "LIGHTBLUE", "LIGHTGREEN", "LIGHTCYAN", 
    "LIGHTRED", "LIGHTMAGENTA", "YELLOW", "WHITE" 
    };

BYTE GetColor(char *color)
    {
    for(int i = 0; i < 16; i++)
        if(!stricmp(color,colorstrings[i]))
            return i;
    return 0xff;
    }



BOOL ChkDupe::FilesExist(void)
    {
    FindFile f1("DUPES.IDX",ALL_FILES);
    if(f1.Found())
        {
        FindFile f2("DUPES.DAT",ALL_FILES);
        if(f2.Found())
            return TRUE;
        }
    return FALSE;
    }

void ChkDupe::ShowDupes(void)
    {       
    screen.Cursor(SCR_CURSOR_OFF);
    screen.AtSay(0,0,ShowDupe);
    screen.AtSay(screen.Lines()-1,0,
        "Move <Sp>Tag <Ret>View <Del>Delete <F7>Purge "
        "<F9>Build <F10>Compare  <Esc>Exit");

    pathW = new Window("Path:",MakePosition(2,2,4,76));
    pathW->Open();

    DWORD position = MakePosition(6,2,(screen.Lines() > 25 ? 42 : 18),
#if defined(DEBUG)
60);
#else
46);
#endif

    Status = new Window("Status",MakePosition(6,53,(screen.Lines() > 25 ? 42 : 18),
        25));
    Status->Open();

    if(!FilesExist())
        {
        if(!FindDuplicates())
            return;
        }
    else if(GetArgCount())      // files exist but command-line spec
        {
        MsgBoxPrompt m("Command-Line Arguments Specified...","Re-build duplicate file tables? (Y/N)");
        if(m.Yes())
            FindDuplicates();
        }

    char *title = "   File        Date      Time       Size        ";
    myScroller = new MyScroller(pathW,title,position);

    myScroller->Init((screen.Lines() > 25 ? 39 : 15)*2,50);

    myScroller->SetColors(
        MakeBG(colors[SCROLL_CBG])+colors[SCROLL_CFG],
        MakeBG(colors[SCROLL_SCBG])+colors[SCROLL_SCFG],
        MakeBG(colors[SCROLL_SNBG])+colors[SCROLL_SNFG],
        MakeBG(colors[SCROLL_NBG])+colors[SCROLL_NFG],
        MakeBG(colors[SCROLL_DNBG])+colors[SCROLL_DNFG],
        MakeBG(colors[SCROLL_DCBG])+colors[SCROLL_DCFG]);

    myScroller->Open();

    while(ScreenMgr(keyboard.Get()));

//    screen.Cursor(SCR_CURSOR_ON);
    delete myScroller;

    delete Status;
    delete pathW;
    }


BOOL ChkDupe::FindDuplicates(void)
    {
    char oldtitle[50];
    pathW->GetTitle(oldtitle);

    PopWin pop("Finding Duplicates...",MakePosition(10,20,5,26));
    pop.Open();
    pop.AtSay(1,0,"   Please stand by.");
    FindDupe finddupe(Status, pathW);
    char searchdirs[200];
    BOOL retval = finddupe.FindDuplicates(
        Settings.GetLine(MySettings[SEARCHDIRS].name,searchdirs));
    pop.Close();
    pathW->SetTitle(oldtitle);

    if(!retval && finddupe.numFound == 0)
        {
        MsgBox("Finding Duplicates","No duplicates found");
        return (FilesExist() ? TRUE : FALSE);
        }

    return retval;
    }

BOOL ChkDupe::ScreenMgr(int key)
    {
    switch(key)
        {
        case KEY_SPACE:             // select or de-select line
            myScroller->Select();
            break;

        case KEY_DEL:               // delete all selected entries and re-display
            myScroller->Delete();
            break;

        case KEY_ENTER:             // call file viewer to view this file
            {
            char *args[3];
            char progname[80];
            char filename[80];

            if(myScroller->IsDeleted())
                break;
            args[0] = Settings.GetLine(MySettings[VIEWER].name,progname);
            if(!args[0])
                args[0] = MySettings[VIEWER].value;
            args[1] = myScroller->CurFileName(filename);
            args[2] = NULL;
            screen.Exec(args[0],args);
            }
            break;

        case KEY_ESC:
            return FALSE;

        case KEY_F7:
            {
            PopWin pop("Purging Files...",MakePosition(10,20,5,26));
            pop.Open();
            pop.AtSay(1,0,"   Please stand by.");
            myScroller->Purge();
            pop.Close();
            myScroller->Paint();
            }
            break;

        case KEY_F9:
            if(GetArgCount() == 0)
                {
                char searchdirs[200];
                if(!strlen(Settings.GetLine(MySettings[SEARCHDIRS].name,searchdirs)))
                    {
                    MsgBox("Unable to find duplicates","No search directories specified");
                    break;
                    }       
                }
            myScroller->CloseFiles();
            if(!FindDuplicates())
                return FALSE;
            myScroller->ReInit();   // reopen files, reinitialize scroller
            break;

        case KEY_F10:
            char *comptitle = "File Compare";
            if(myScroller->CompareSetup())
                {
                PopWin pop("Comparing Files...",MakePosition(10,20,5,26));
                pop.Open();
                pop.AtSay(1,0,"   Please stand by.");
                if(myScroller->FileCompare())
                    MsgBox(comptitle,"Files are Identical!");
                else
                    MsgBox(comptitle,"Files differ!");
                pop.Close();
                Status->Puts("Compare complete.");
                }
            else
                Status->Puts("Compare pending...");
            break;

        case KEY_F1:
            {
            PopWin pop("ShowDupe Help",MakePosition(5,5,16,70));
            pop.Open();
            pop.Printf(ShowDupeHelp);
            pop.Printf("\nPress any key to continue...");
            keyboard.Get();
            pop.Close();
            }
            break;

        case KEY_CTRLENTER:
            screen.Exec("COMMAND.COM",NULL,
                "To return to SHOWDUPE, type \'exit\'.");
            break;

        default:
            myScroller->KeyProcess(key);
            break;
        }
    return TRUE;
    }

ChkDupe::~ChkDupe(void)
    {
    }

void ChkDupe::terminate(void)    
    {
    printf(ShowDupe);
    printf("\n");
    printf(ShowDupeHelp);
    exit(0);
    }

void ChkDupe::terminate(char *msg)
    {
    printf(msg);
    exit(0);
    }

void ChkDupe::InitApp(void)
    {
    char temp[30];
    int mode;

    Settings.GetLine(MySettings[SCREENMODE].name,temp);
    if(!stricmp(temp,"EGAVGA"))
        mode = VIDMODE_EGAVGA;
    else
        mode = VIDMODE_DEFAULT;

    for(int i = 0; i < MAXCOLORS; i++)
        {
        Settings.GetLine(MySettings[i].name,temp);
        if((colors[i] = GetColor(temp)) == 0xff)
            colors[i] = GetColor(MySettings[i].value);
        }

    screen.Init(mode,MakeBG(colors[0])+colors[1],MakeBG(colors[2])+colors[3]);

    screen.Paint();
    Window::SetDefaultColors(MakeBG(colors[4])+colors[5]);
    }

void ChkDupe::ShowStats(void)
    {
#ifdef NOTYET
    char lastfile[13];
    lastfile[0] = '\0';

    unsigned total_files = 0, dupe_files = 0, org_files = 0;
    long total_size = 0L, dupe_size = 0L, org_size = 0L;
    long curr_offset = IndexFile.CurPosition();

    IndexFile.Offset(0L);

    while(IndexFile.Read(sizeof(OutBuf),&OutBuf) != 0)
        {
        GetData(&DataFile,OutBuf.offset);

        total_size += DataBuf.size;
        total_files++;

        if(!strcmp(OutBuf.buf,lastfile))        // if a duplicate
            {
            dupe_files++;
            dupe_size += DataBuf.size;
            }
        else
            {
            org_files++;
            org_size += DataBuf.size;
            }

        strcpy(lastfile,OutBuf.buf);
        }

    printf("ChkDupe has found:\nOut of %u files which comprise %ld bytes\n",
        total_files,total_size);
    printf("A total of %u files have a total of %u duplicates\n",
        org_files,dupe_files);
    printf("These duplicates occupy a total of %ld bytes\n\n",dupe_size);

    IndexFile.Offset(curr_offset);
#endif
    }

void main(void)
    {
    ChkDupe myApp;
    }



