// myscroll.cpp RHS 11/5/91

#include<malloc.h>
#include"msgbox.h"
#include"myscroll.h"


char *MyScroller::GetBuffer(int bufnum)     {   return bufMgr[bufnum]->buffer;  }
BYTE MyScroller::GetAttribute(int bufnum)   {   return bufMgr[bufnum]->attribute;   }
void MyScroller::SetBuffer(int bufnum, char *buffer)    {   strcpy(bufMgr[bufnum]->buffer,buffer);  }
void MyScroller::SetAttribute(int bufnum, BYTE attribute)   {   bufMgr[bufnum]->attribute = attribute;  }

void MyScroller::ReInit(void)
    {
    startRow = endRow = 0;
    numRows = (int)(IndexFile.Size()/sizeof(OUTBUF));
    OpenFiles();
    IndexFile.Offset(0L);   // go to beginning of file
    startBuf = curBuf = 0;
    endBuf = (numRows < clientheight) ? numRows-1 : clientheight-1;
    FillBufs();
    Clear();
    Paint();
    DispPath();
    }

MyScroller::MyScroller(Window *pathw,char *title, DWORD position, BYTE colors)
    : Scroller(title,position,colors)
    {
//    numbuffers = bufMgr.Init(num,size);
    startRow = endRow = 0;
    numRows = (int)(IndexFile.Size()/sizeof(OUTBUF));
    OpenFiles();
    IndexFile.Offset(0L);   // go to beginning of file
    pathW = pathw;
    purges_ok = FALSE;
    }

MyScroller::~MyScroller(void)
    {
    CloseFiles();
    farfree(DirNames);
    }

void MyScroller::OpenFiles(void)
    {
    if(IndexFile.IsOpen())
        IndexFile.Close();
    if(DataFile.IsOpen())
        DataFile.Close();
    IndexFile.Open("rb+");
    DataFile.Open("rb+");
    }

void MyScroller::CloseFiles(void)
    {
    IndexFile.Close();
    DataFile.Close();
    }

void MyScroller::Init(int numbufs, int sizebufs)
    {
    Scroller::Init(numbufs,sizebufs);
    numbuffers = bufMgr.Init(numbufs,sizebufs);
    endBuf = (numRows < clientheight) ? numRows-1 : clientheight-1;
    DirNames = (char far *)farmalloc(numbufs*DIRNAMELEN);
    FillBufs();
    *file1 = *file2 = '\0';
    }

void MyScroller::Change(int item, char *contents, BYTE attribute, long recno)
    {
    SetBuffer(item,contents);
    SetAttribute(item,attribute);
    bufMgr[item]->recno = recno;
    }

void MyScroller::Open(void)
    {
    Scroller::Open();
    DispPath();
    }

int MyScroller::MaxBufs(void)
    {
    if((endRow-startRow-1) < (numbuffers-1))
        return endRow-startRow-1;     
    return numbuffers-1;
    }

void MyScroller::BufMgt(int action)
    {
    switch(action)
        {
        case SCROLL_HOME:
            if(bufMgr[0]->recno > 0L)
                {
                IndexFile.Offset(0L);           // go to beginning of file
                startRow = startBuf = 0;
                FillBufs();
                buffer_changed = TRUE;
                }
//            if(startBuf>0 && startRow == bufMgr[0]->recno)
//                startBuf = 0;
            break;
        case SCROLL_END:
            if((endRow < numRows) && (bufMgr[numbuffers-1]->recno != numRows-1))
                {
                long offset;
                IndexFile.Offset(offset = (IndexFile.Size()-(numbuffers*sizeof(OUTBUF))));
                startRow = (int)(offset/sizeof(OUTBUF));
                FillBufs();
                buffer_changed = TRUE;
                }
            break;
        case SCROLL_PGUP:
            if(((startBuf - (int)Lines()) < 0) && (startRow > 0))
                {
                if((startRow -= (numbuffers/2)) < 0)   
                    startRow = 0;
                IndexFile.Offset((startRow*1L)*sizeof(OUTBUF));
                FillBufs();
                buffer_changed = TRUE;
                }
            break;
        case SCROLL_PGDN:
            if((endBuf == numbuffers-1) && (endRow < (numRows-1)))
                {
                if((endRow += (numbuffers/2)) > (numRows-1))
                    endRow = numRows-1;
                if((startRow = endRow-numbuffers) < 0)
                    startRow = 0;
                IndexFile.Offset((startRow*1L)*sizeof(OUTBUF));
                FillBufs();
                buffer_changed = TRUE;
                }
            break;
        case SCROLL_UP:
            if((startBuf == 0) && (startRow != 0))   // if no records prior
                {
                int temp = startRow;
                if((startRow -= (numbuffers/2)) < 0)
                    startRow = 0;
                else
                    temp = numbuffers/2;

                IndexFile.Offset((startRow*1L)*sizeof(OUTBUF));
                FillBufs();
                startBuf += temp;
                endBuf += temp;
                curBuf += temp;
                }
            break;
        case SCROLL_DN:
            if((endBuf == numbuffers-1) && (endRow < (numRows-1)))
                {
                if((endRow += (numbuffers/2)) > (numRows-1))
                    endRow = numRows-1;
                if((startRow = endRow-numbuffers) < 0)
                    startRow = 0;
                IndexFile.Offset((startRow*1L)*sizeof(OUTBUF));
                FillBufs();
                int temp = numbuffers/2;
                startBuf -= temp;
                endBuf -= temp;
                curBuf -= temp;
                buffer_changed = TRUE;
                }
            break;
        }
    }

void MyScroller::KeyProcess(int key)
    {
//    Screen::AtSay(1,0,
//"startRow=%04d endRow=%04d startBuf=%02d endBuf=%02d curBuf=%02d",
//startRow,endRow,startBuf,endBuf,curBuf);

    switch(key)
        {
        case KEY_HOME:          // initialize screen buffers with data
            Home();
            break;

        case KEY_END:                   // goto end of file
//        if(endRow < numRows-1)
            End();
            break;

        case KEY_PGUP:                  // show previous page of lines
            PgUp();
            break;

        case KEY_PGDN:              // show next page of lines
//            if(endRow < numRows-1)
            PgDn();
            break;

        case KEY_UP:                // move to prev group or shift screen down and add to start
            Up();
            break;

        case KEY_DOWN:              // move to next group or shift screen up and add to end
            Down();
            break;
        }
//    Screen::AtSay(5,0,
//"startRow=%04d endRow=%04d startBuf=%02d endBuf=%02d curBuf=%02d",
//startRow,endRow,startBuf,endBuf,curBuf);

    buffer_changed = FALSE;
    DispPath();
    }

char *trim(char *str)
    {
    char *p = strchr(str,' ');

    if(p)
        *p = '\0';
    return str;
    }

void MyScroller::DispPath(void)
    {
    char formatbuffer[80];

    SetWords((void far *)formatbuffer,0,WordSize(formatbuffer));
    _fstrcpy(formatbuffer,&DirNames[curBuf*DIRNAMELEN]);
    pathW->Clear();
    pathW->AtSay(0,0,formatbuffer);
    }

void MyScroller::FillBufs(void)
    {
    int i;
    char formatbuffer[80];
    
    for(i = 0; i < numbuffers; i++)
        {
        if(!GetRecord())
            break;
        FormatRecord(formatbuffer);
        {
        char buf[15];
        sprintf(buf,"  %04ld",(startRow+i)*1L);
        strcat(formatbuffer,buf);
        }
        Change(i,formatbuffer,OutBuf.status,(startRow+i)*1L);
        _fstrcpy(&DirNames[i*DIRNAMELEN],DirName.dirname);
        }
    endRow = (startRow+i);
    purges_ok = TRUE;
    }

void MyScroller::FormatRecord(char *buf)
    {
    sprintf(buf,"%-12s  %02d/%02d/%02d  %02d:%02d:%02d  %10ld",
        OutBuf.buf,
        ((DataBuf.date & 0x01ff) >> 5),
        DataBuf.date & 0x001f,
        ((DataBuf.date >> 9) + 80),
        (DataBuf.time >> 11),
        ((DataBuf.time >> 5) & 0x003f),
        ((DataBuf.time & 0x001f) << 1),
        DataBuf.size);
    }

#include<errno.h>

void MyScroller::Delete(void)
    {
    char formatbuffer[80];

    CurFileName(formatbuffer);

    File file(formatbuffer);
    extern int errno;
    if((file.Delete() == 0) || errno == ENOENT)
        {
        long save_position = IndexFile.CurPosition();
        IndexFile.ReadAt(bufMgr[curBuf]->recno*sizeof(OUTBUF)*1L,sizeof(OUTBUF),&OutBuf);
        OutBuf.status = SCROLLER_DELETED;
        SetAttribute(curBuf,SCROLLER_DELETED);
        IndexFile.WriteAt(bufMgr[curBuf]->recno*sizeof(OUTBUF)*1L,sizeof(OUTBUF),&OutBuf);       // write index entry
        IndexFile.Offset(save_position);
        }
    Paint();
    }

   
void MyScroller::Purge(void)
    {
    IndexFile.Offset(0L);

    int i;
    char formatbuffer[80];
    long cur_position;
    extern int errno;

    for( i = 0; i < numRows; i++)
        {
        cur_position = IndexFile.CurPosition();
        IndexFile.Offset(cur_position);     // re-position in case just after a write
        if(!GetRecord())
            break;
        if(OutBuf.status & SCROLLER_SELECTED_NORMAL)
            {
            strcpy(formatbuffer,DirName.dirname);
            strcat(formatbuffer,OutBuf.buf);
            File file(formatbuffer);

            if((file.Delete() == 0) || errno == ENOENT)
                {
                OutBuf.status = SCROLLER_DELETED;
                IndexFile.WriteAt(cur_position,sizeof(OUTBUF),&OutBuf);       // write index entry
                IndexFile.Flush();
                }
            else
                MsgBox("Unable to Delete File:",formatbuffer);
            }
        }
    IndexFile.Offset((startRow*1L)*sizeof(OUTBUF));
    FillBufs();
    Paint();
    }

char *MyScroller::CurFileName(char *buf)
    {
    _fstrcpy(buf,&DirNames[curBuf*DIRNAMELEN]);
    char temp[13];
    strncpy(temp,bufMgr[curBuf]->buffer,12);
    temp[12] = '\0';
    strcat(buf,temp);
    trim(buf);
    return buf;
    }

void MyScroller::Select(void)
    {
    BYTE attrib_old = bufMgr[curBuf]->attribute;

    if(attrib_old & SCROLLER_DELETED)
        return;
    BYTE attrib_new = Scroller::Select();

    if(attrib_old == attrib_new)
        return;
    long save_position = IndexFile.CurPosition();

    IndexFile.ReadAt(bufMgr[curBuf]->recno*sizeof(OUTBUF)*1L,sizeof(OUTBUF),&OutBuf);
        // turn off CURRENT bit
    OutBuf.status = (attrib_new & 0xfe);
    IndexFile.WriteAt(bufMgr[curBuf]->recno*sizeof(OUTBUF)*1L,sizeof(OUTBUF),&OutBuf);       // write index entry
    IndexFile.Offset(save_position);
    }

BOOL MyScroller::CompareSetup(void)
    {
    if(*file1 && *file2)
        *file1 = *file2 = '\0';
    char temp[13];
    if(!*file1)
        {
        CurFileName(file1);
        return FALSE;
        }
    if(!*file2)
        {
        CurFileName(file2);
        return TRUE;
        }
    }

BOOL MyScroller::FileCompare(void)
    {
    if(!strcmp(file1,file2))
        return TRUE;

    File f1(file1), f2(file2);
    long size;

    if((size = f1.Size()) != f2.Size())
        return FALSE;
    BYTE byte1, byte2;
    f1.Open("rb");
    f2.Open("rb");
    BYTE buf1[512], buf2[512];

    int j,k;
    for(long i = 0L; i < size; i += k)
        {
        k = f1.ReadAt(i,512,buf1);
        f2.ReadAt(i,512,buf2);
        for(j = 0; j < k; j++)
            if(buf1[j] != buf2[j])
                return FALSE;
        }
    return TRUE;
    }

BOOL MyScroller::IsDeleted(void)
    {
    if(GetAttribute(curBuf) & SCROLLER_DELETED)
        return TRUE;
    return FALSE;
    }


