// scroller.h RHS 10/15/91

#if !defined(SCROLLER_H)
#define SCROLLER_H

#include"window.h"

enum { SCROLL_HOME, SCROLL_END, SCROLL_PGUP, SCROLL_PGDN, 
    SCROLL_UP, SCROLL_DN };

const BYTE SCROLLER_NORMAL  = 0x00;
const BYTE SCROLLER_CURRENT = 0x01;
const BYTE SCROLLER_SELECTED_NORMAL = 0x02;
const BYTE SCROLLER_SELECTED_CURRENT = (SCROLLER_SELECTED_NORMAL | SCROLLER_CURRENT);
const BYTE SCROLLER_DELETED = 0x04;
const BYTE SCROLLER_DELETED_CURRENT = (SCROLLER_DELETED | SCROLLER_CURRENT);

const BYTE SCROLLER_NORMAL_COLORS = MakeBG(VID_BLUE)+VID_WHITE;
const BYTE SCROLLER_CURRENT_COLORS = MakeBG(VID_LIGHTGRAY)+VID_WHITE;
const BYTE SCROLLER_SELECTED_NORMAL_COLORS = MakeBG(VID_BLUE)+VID_YELLOW;
const BYTE SCROLLER_SELECTED_CURRENT_COLORS = MakeBG(VID_LIGHTGRAY)+VID_YELLOW;
const BYTE SCROLLER_DELETED_NORMAL_COLORS = MakeBG(VID_BLUE)+VID_LIGHTGRAY;
const BYTE SCROLLER_DELETED_CURRENT_COLORS = MakeBG(VID_LIGHTGRAY)+VID_DARKGRAY;
       
class Scroller : public Window 
    {
private:
    int bufsize;
    BYTE ScrColors[6];
protected:
    int startBuf;               // first buffer displayed
    int endBuf;                 // last buffer displayed
    int curBuf;                 // current buffer
    int numbuffers;             // total buffers created
    BOOL buffer_changed;

    void DispBuffer(int line, int bufnum, BYTE attribute = SCROLLER_NORMAL);
    virtual BYTE Colors(BYTE color_offset)  {   return ScrColors[color_offset]; }
    virtual void BufMgt(int action) = 0;

public:
    Scroller(char *title, DWORD position, BYTE colors, 
        int numbuffers, int bufsize);
    Scroller(char *title, DWORD position, BYTE colors = SCROLLER_NORMAL_COLORS);
    int Init(int num, int size);
    void Open(void);
    void Paint(void);

    void Home(void);
    void End(void);
    void PgUp(void);
    void PgDn(void);
    void Up(void);
    void Down(void);

    void SetColors(
        BYTE current        =   SCROLLER_CURRENT_COLORS,
        BYTE select_current =   SCROLLER_SELECTED_CURRENT_COLORS,
        BYTE select_normal  =   SCROLLER_SELECTED_NORMAL_COLORS,
        BYTE normal         =   SCROLLER_NORMAL_COLORS,
        BYTE del            =   SCROLLER_DELETED_NORMAL_COLORS,
        BYTE del_cur        =   SCROLLER_DELETED_CURRENT_COLORS
        );

    BYTE Select(void);          // strictly a toggle
    int NumBufs(void)           {   return numbuffers;      }

    virtual char *GetBuffer(int bufnum) = 0; 
    virtual BYTE GetAttribute(int bufnum) = 0; 
    virtual void SetBuffer(int bufnum, char *newbuf) = 0;
    virtual void SetAttribute(int bufnum, BYTE newattrib) = 0;
    virtual int MaxBufs(void) = 0;
#ifdef NOTYET
    void Delete(void);
#endif
    };

#endif

