// stddefs.h

#if !defined(STDDEFS_H)
#define STDDEFS_H

#include<string.h>

inline char Lastchar(char *str)
    {
    return str[strlen(str)-1];
    }

#if !defined(BOOL)
typedef int BOOL;
#endif

#if !defined(BYTE)
typedef unsigned char BYTE;
#endif

#if !defined(WORD)
typedef unsigned int WORD;
#endif

#if !defined(DWORD)
typedef unsigned long DWORD;
#endif

const TRUE = 1;
const FALSE = 0;
const DEFAULTLINELEN = 512;

#if !defined(MAKEWORD)
inline WORD MAKEWORD(BYTE hi, BYTE lo)
    {
    return (WORD)(lo | (((WORD)hi) << 8));
    }
#endif

#if !defined(LOBYTE)
inline BYTE LOBYTE(WORD w)
    {
    return (BYTE)w;
    }
#endif

#if !defined(HIBYTE)
inline BYTE HIBYTE(WORD w)
    {
    return (BYTE)((w >> 8) & 0x00ff);
    }
#endif

#if !defined(MAKEDWORD)
inline DWORD MAKEDWORD(WORD hi, WORD lo)
    {
    return (DWORD)(lo | (((DWORD)hi) << 16));
    }
#endif

#if !defined(LOWORD)
inline WORD LOWORD(DWORD l)
    {
    return (WORD)(l);
    }
#endif

#if !defined(HIWORD)
inline WORD HIWORD(DWORD l)
    {
    return (WORD)((l >> 16) & 0x0000ffff);
    }
#endif

#define WordSize(item)  (sizeof(item)/sizeof(WORD))

inline int max(int a, int b)
    {
    return ((a > b) ? a : b);
    }

inline long max(long a, long b)
    {
    return ((a > b) ? a : b);
    }

inline int min(int a, int b)
    {
    return ((a < b) ? a : b);
    }

inline long min(long a, long b)
    {
    return ((a < b) ? a : b);
    }

#endif

