// DEMO4.C  Pen-aware Windows application that demonstrates 
// keyboard text input or handwritten input via a dialog, validating
// the input with USERDICT.DLL user dictionary word lists.  The data 
// is then displayed in the main window.
// Copyright (C) 1991 Ray Duncan

#define WIN31

#include "windows.h"
#include "penwin.h"
#include "demo4.h"

HANDLE hInst;                               // instance handle
HWND hWnd = 0;                              // main window handle
HWND hBeditCity = 0;                        // City BEDIT control handle
HWND hBeditState = 0;                       // State BEDIT control handle
HANDLE hUserDict = 0;                       // user dictionary handle
unsigned hCityList = 0;                     // handle for city wordlist
unsigned hStateList = 0;                    // handle for state wordlist
FARPROC lpUserDict = NULL;                  // user dictionary entry point
HANDLE hPenWin = 0;                         // Pen Windows module handle

#define INPUTSIZE 80                        // max length of input
#define OUTPUTSIZE 256                      // max length of output

char buf1[INPUTSIZE];                       // user's city input buffer
char buf2[INPUTSIZE];                       // user's state input buffer
char buf3[OUTPUTSIZE];                      // formatted output buffer

unsigned CancelFlag = TRUE;                 // TRUE if input cancelled

//
// WinMain - entry point from Windows.  Registers window class,
// creates main window, processes messages until WM_QUIT received.
//
int PASCAL WinMain(HANDLE hInstance, 
    HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                     

    hInst = hInstance;                      // save this instance handle

    if(!hPrevInstance)                      // if first instance,
        if(!InitApplication(hInstance))     // register window class
            return(FALSE);                  // exit if couldn't register

    if(!InitInstance(hInstance, nCmdShow))  // create this instance's window
    {
        MessageBox(0, "Initialization failed!", "DEMO4", MB_OK|MB_ICONSTOP);
        return(FALSE);
    }

    RegisterPenApp(RPA_DEFAULT, TRUE);      // enable HEDIT/BEDIT controls

    while(GetMessage(&msg, NULL, 0, 0))     // while message != WM_QUIT
    {
        TranslateMessage(&msg);             // translate virtual key codes
        DispatchMessage(&msg);              // dispatch message to window
    }
    return(msg.wParam);                     // return code = WM_QUIT value
}

//
//  InitApplication - registers window class for this application
//
BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;
                                            // set class parameters
    wc.style = NULL;                        // class style
    wc.lpfnWndProc = MainWndProc;           // class callback function
    wc.cbClsExtra = 0;                      // extra per-class data
    wc.cbWndExtra = 0;                      // extra per-window data
    wc.hInstance = hInstance;               // handle of class owner
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);     // default icon
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);       // default cursor
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); // background color 
    wc.lpszMenuName =  "DemoMenu";          // name of menu resource
    wc.lpszClassName = "DemoWinClass";      // name of window class

    return(RegisterClass(&wc));             // register class, return flag
}

//
// InitInstance - creates main window for this application instance
//
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    hWnd = CreateWindow(                    // create frame window
        "DemoWinClass",                     // window class name
        "Pen Windows Demo #4",              // text for title bar
        WS_OVERLAPPEDWINDOW,                // window style
        CW_USEDEFAULT,                      // default horizontal position
        CW_USEDEFAULT,                      // default vertical position
        CW_USEDEFAULT,                      // default width
        CW_USEDEFAULT,                      // default height
        NULL,                               // no parent window
        NULL,                               // use class default menu
        hInstance,                          // window owner
        NULL                                // unused pointer
    );

    if(!hWnd) return(FALSE);                // error, can't create window

                                            // link to user dictionary
    if((hUserDict = LoadLibrary("userdict.dll")) <= 32)
        return(FALSE);                      // give up if dynlink failed
    if((lpUserDict = GetProcAddress(hUserDict, "DictionaryProc")) == NULL)
        return(FALSE);                      // give up if dynlink failed

                                            // open the user word lists
    (lpUserDict)(DIRQ_OPEN, (LPSTR) "c:\\source\\cities.dic", 
                 (LPWORD) &hCityList, sizeof(hCityList), 0L, 0L);
    (lpUserDict)(DIRQ_OPEN, (LPSTR) "c:\\source\\states.dic", 
                 (LPWORD) &hStateList, sizeof(hStateList), 0L, 0L);
    if((!hCityList) || !(hStateList))       // give up if word list
        return(FALSE);                      // files were not found

    ShowWindow(hWnd, nCmdShow);             // make window visible
    UpdateWindow(hWnd);                     // force WM_PAINT message
    return(TRUE);                           // return success flag
}

//
// MainWndProc - callback function for main application window
//
long FAR PASCAL MainWndProc(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
    HDC hdc;                                // device context handle
    PAINTSTRUCT ps;                         // painting info structure
    RECT rect;                              // receives client rectangle

    switch (wMsg) 
    {
        case WM_COMMAND:                    // menu command received,
            DoCommand(hWnd, wParam);
            break;

        case WM_PAINT:                      // window needs repainting
            hdc = BeginPaint(hWnd, &ps);    // get device context
            GetClientRect(hWnd, &rect);     // get client rectangle
            if(!CancelFlag)                 // format user's input  
                wsprintf(buf3, "The city is %s, the state is %s.", 
                         (LPSTR) buf1, (LPSTR) buf2);
            else strcpy(buf3, "No data entered!");
            DrawText(hdc, buf3, -1, &rect,  // display formatted text
                DT_SINGLELINE | DT_CENTER | DT_VCENTER);
            EndPaint(hWnd, &ps);            // release device context
            break;

        case WM_SIZE:                       // window resized
            InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
            UpdateWindow(hWnd);             // force WM_PAINT message
            break;

        case WM_DESTROY:                    // window being destroyed
            PostQuitMessage(0);
            break;

        default:                            // let Windows handle it
            return(DefWindowProc(hWnd, wMsg, wParam, lParam));
    }

    return(0);
}

//
// DoCommand - handles menu command messages.  
//
void DoCommand(HWND hWnd, WORD wParam)
{
    FARPROC lpProc;                         // far pointer to callback 

    switch(wParam)                          // decode it
    {
        case IDM_EXIT:                      // user picked File-Quit
            SendMessage (hWnd, WM_CLOSE, 0, 0L);
            break;

        case IDM_ENTER:                     // user picked Edit-Enter
            lpProc = MakeProcInstance(EntryDlgProc, hInst);
            CancelFlag = DialogBox(hInst, "TextEntryBox", hWnd, lpProc);
            InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
            UpdateWindow(hWnd);             // force WM_PAINT message
            FreeProcInstance(lpProc);
            break;

        default:                            // unknown command, ignore it
            break;
    }
}

//
// EntryDlgProc - callback function for "Text Entry..." dialog
//
BOOL FAR PASCAL EntryDlgProc(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
    RC rc;

    switch (wMsg) 
    {
        case WM_INITDIALOG:                 // dialog box initialization

                                            // get BEDIT window handles 
            hBeditCity = GetDlgItem(hDlg, IDD_EDITCITY);
            hBeditState = GetDlgItem(hDlg, IDD_EDITSTATE);

                                            // configure RC for City BEDIT
            SendMessage(hBeditCity, WM_HEDITCTL, HE_GETRC, (LONG) ((LPRC) &rc));
            rc.lRcOptions = rc.lRcOptions | RCO_NOSPACEBREAK | RCO_SUGGEST;
            rc.rglpdf[0] = lpUserDict;
            rc.rglpdf[1] = NULL;
            rc.alc = ALC_ALPHA;
            SendMessage(hBeditCity, WM_HEDITCTL, HE_SETRC, (LONG) ((LPRC) &rc));

                                            // configure RC for State BEDIT
            SendMessage(hBeditState, WM_HEDITCTL, HE_GETRC, (LONG) ((LPRC) &rc));
            rc.lRcOptions = rc.lRcOptions | RCO_NOSPACEBREAK | RCO_SUGGEST;
            rc.rglpdf[0] = lpUserDict;
            rc.rglpdf[1] = NULL;
            rc.alc = ALC_ALPHA;
            SendMessage(hBeditState, WM_HEDITCTL, HE_SETRC, (LONG) ((LPRC) &rc));

            return (TRUE);                  // signal message processed

        case WM_COMMAND:                    // command received
            if(HIWORD(lParam) == EN_SETFOCUS)
            {                               // BEDIT receiving focus,
                if(wParam == IDD_EDITCITY)  // select proper word list
                    (lpUserDict)(DIRQ_SETWORDLISTS, (LPWORD) &hCityList,
                                 0L, 1, 0L, 0L);
                else if(wParam == IDD_EDITSTATE)
                    (lpUserDict)(DIRQ_SETWORDLISTS, (LPWORD) &hStateList,
                                 0L, 1, 0L, 0L);
            }
            else if(wParam == IDOK)         // OK button clicked?
            {                               // yes, retrieve text
                GetDlgItemText(hDlg, IDD_EDITCITY,  buf1, INPUTSIZE-1);
                GetDlgItemText(hDlg, IDD_EDITSTATE, buf2, INPUTSIZE-1);
                EndDialog(hDlg, FALSE);     // signal text accepted
            }
            else if(wParam == IDD_CANCEL)   // Cancel button clicked?
            {
                EndDialog(hDlg, TRUE);      // signal input was cancelled
            }
    }
    return(FALSE);                          // signal message not processed
}


