'CLRPRINT.BAS - graphics printing routine accepts a background color

'$INCLUDE: 'QB.BI'      'this defines the RegTypeX TYPE variable
 
DECLARE SUB ColorPrint (text$, row%, col%, fc%, bc%)
DIM SHARED Registers AS RegTypeX

SCREEN 9

FOR i = 9 TO 210 STEP 10    'draw ellipses to show it's graphics mode
  Clr = Clr + 1
  CIRCLE (310, i), i, Clr MOD 16, , , .6
NEXT

CALL ColorPrint(" ColorPrint - Microsoft QuickBasic ", 3, 23, 4, 7)
CALL ColorPrint(" Graphics text with a background color! ", 5, 20, 7, 1)

FOR bc% = 0 TO 15           'display all possible color combinations
  FOR fc% = 0 TO 15
    CALL ColorPrint(HEX$(fc%), 8 + bc%, 32 + fc%, fc%, bc%)
  NEXT
NEXT

SUB ColorPrint (text$, row%, col%, fc%, bc%) STATIC

    c$ = STRING$(LEN(text$), 219)   'create a string of solid characters

    Registers.ax = &H1300           'video service 13h, subfunction 0
    Registers.bx = bc%              'BH = page (0), BL = color
    Registers.cx = LEN(text$)       'CX = string length
    Registers.dx = 256 * (row% - 1) + (col% - 1)  'DH = row, DL = column
    Registers.es = VARSEG(c$)       'ES = string data segment
    Registers.bp = SADD(c$)         'BP = string address
    CALL InterruptX(&H10, Registers, Registers)   'call the BIOS to print it

    Registers.bx = (fc% XOR bc%) + &H80 'BL = color, +&H80 means use XOR
    Registers.es = VARSEG(text$)    'ES = string data segment
    Registers.bp = SADD(text$)      'BP is the string address
    CALL InterruptX(&H10, Registers, Registers)   'call the BIOS

END SUB

