;GetAbs.ASM
;Copyright (c) 1992 Jay Munro
;First Published in PC Magazine June 16, 1992
;Syntax
;  Declare Function GetAbs%(Byval Segment%)
;  GoodSelector% = GetAbs%(&hB000)
;---------------------------------------------------------------------------
; GetAbs.ASM takes an incoming segment value and replaces it with
; a Windows compatible selector if it matches one of the 9 possible exported
; values.  If the value doesn't match it is checked to see if it is a valid
; selector, first a writeable one, then a readable one.  In the event it
; fails all the tests, a -1 is returned otherwise the original value or the
; substituted selector is returned.
;----------------------------------------------------------------------------

.286P                           ;protected instructions below

.Model Medium

    Public   GetAbs
    Include  Labnotes.inc
    
    Extrn   __0000H :ABS
    Extrn   __0040H :ABS
    Extrn   __A000H :ABS
    Extrn   __B000H :ABS
    Extrn   __B800H :ABS
    Extrn   __C000H :ABS
    Extrn   __D000H :ABS
    Extrn   __E000H :ABS
    Extrn   __F000H :ABS

.Code

GetAbs Proc Far
    WinProlog                   ;standard export setup
    Mov  AX,[BP+6]              ;get incoming value
    Or   AX,AX                  ;asking for segment 0?
    Jnz  @F
    Mov  AX,__0000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0040h               ;Segment 0040h ?
    Jnz  @F
    Mov  AX,__0040h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0A000h              ;Segment A000h ?
    Jnz  @F
    Mov  AX,__A000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0B000h              ;Segment B000h ?
    Jnz  @F
    Mov  AX,__B000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0B800h              ;Segment 0040h ?
    Jnz  @F
    Mov  AX,__B800h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0C000h              ;Segment C000h ?
    Jnz  @F
    Mov  AX,__C000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0D000h              ;Segment D000h ?
    Jnz  @F
    Mov  AX,__D000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0E000h              ;Segment E000h ?
    Jnz  @F
    Mov  AX,__E000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    Cmp  AX,0F000h              ;Segment F000h ?
    Jnz  @F
    Mov  AX,__F000h             ;get selector
    Jmp  Exit                   ;get out
@@:
    VERW AX                     ;is it writeable?
    Jz   Exit
    VERR AX                     ;not writeable, then is it readable
    Jz   Exit                   ;
    
    Mov  AX,-1                  ;none of the above
Exit:
    WinEpilog
    Ret 2
GetAbs EndP
End
