;MK_CV.ASM
;Copyright (c) 1991 Jay Munro
;First Published in PC Magazine June 16, 1992
;----------------------------------------------------------------------------
;MKx and CVx are replacement routines for Visual Basic, working identically
;as their QuickBasic counterparts.  The only requirement is that they be
;declared to be recognized.

;Syntax:  (same for all except appropriate types inserted)
;Declare Function MKI$ Lib "LabNotes.DLL" (Byval IntValue%)
;Declare Function CVI% Lib "LabNotes.DLL" (Byval IntString$)
;
;   A$ = MKI$(I%)       ;integer to string (long,single,double,currancy)
;   I% = CVI%(A$)       ;string to integer (long,single,double,currancy)
;----------------------------------------------------------------------------

.286
.Model Medium
    Include LabNotes.Inc
    Extrn VBDerefHLStr:Proc
    Extrn VBGetHLStrLen:Proc
    Extrn VBCreateHLStr:Proc
    Public MKI,MKL,MKS,MKD,MKC
    Public CVI,CVL,CVS,CVD,CVC

.Code

;----- Integers
MKI Proc Far                    ;Export
    WinProlog                   ;set up header
    Lea  BX,[BP+6]              ;get address of variable on stack
    Push SS                     ;push segment and offset of integer
    Push BX                     ;
    Push 2                      ;2 bytes long
    Call VBCreateHLStr          ;create a string descriptor
    WinEpilog
    Ret 2
MKI  EndP

;----- Singles and Longs
MKS Proc Far                    ;Export
MKL Proc Far                    ;Export
    WinProlog
    Lea  BX,[BP+6]              ;get address of variable on stack
    Push SS                     ;push segment and offset of long
    Push BX
    Push 4                      ;4 bytes long
    Call VBCreateHLStr          ;create a string descriptor
    WinEpilog
    Ret 4
MKL EndP
MKS EndP

;----- Currency and Doubles
MKC Proc Far                    ;Export
MKD Proc Far                    ;Export
    WinProlog
    Lea  BX,[BP+6]              ;get address of variable on stack
    Push SS                     ;push segment and offset of variable
    Push BX
    Push 8                      ;8 bytes long
    Call VBCreateHLStr          ;create a string descriptor to pass back
    WinEpilog
    Ret 8
MKD  EndP
MKC  EndP

;----- Integers
CVI  Proc Far                   ;Export
     WinProlog
     Lds  SI,[BP+6]             ;get address of variable on stack
     Push DS                    ;push segment and offset of variable
     Push SI
     Call VBGetHLStrLen         ;get length of incoming string
     Cmp  AX,2                  ;is it an integer length ?
     Jnz  @F                    ;no, exit now
     Push DS                    ;otherwise push seg & offset to get data
     Push SI
     Call VBDeRefHLStr          ;get data address (DX:AX)
     Mov  DS,DX                 ;transfer it to DS:SI
     Mov  SI,AX
     LodSw                      ;get a word
@@:
     WinEpilog                  ;and leave with word in AX
     Ret 4
CVI  EndP

;----- Longs
CVL  Proc Far                   ;Export
     WinProlog
     Lds  SI,[BP+6]             ;get address of variable on stack
     Push DS                    ;push segment and offset of variable
     Push SI
     Call VBGetHLStrLen         ;get length of incoming string
     Mov  DX,AX                 ;is it a long int in length ?
     Cmp  AX,4                  ;no, exit now
     Jnz  @F                    ;otherwise push seg & offset to get data
     Push DS
     Push SI
     Call VBDeRefHLStr          ;get data address (DX:AX)
     Mov  DS,DX                 ;transfer it to DS:SI
     Mov  SI,AX
     Mov  AX,[SI]               ;move the data into DX:AX
     Mov  DX,[SI+2]             ;and leave with data in DX:AX
@@:
     WinEpilog
     Ret 4
CVL  EndP

;----- Single - 4 bytes
CVS  Proc Far                   ;Export
     WinProlog
     SaveESDISI                 ;save ES,DI,SI macro
     Lds  SI,[BP+8]             ;get address of string into DS:SI
     Push DS                    ;push it to get length
     Push SI
     Call VBGetHLStrLen         ;check the length
     Mov  CX,AX                 ;save it in case it's ok
     Cmp  AX,4                  ;well, is it a single's length?
     Jnz  @F                    ;no exit now
     Push DS                    ;ok, now push DS:SI to get address of data
     Push SI
     Call VBDeRefHLStr          ;get string data
     Mov  DS,DX                 ;transfer address to DS:SI
     Mov  SI,AX
     Mov  DI,[BP+6]             ;get dummy address from VB--phantom paramater
     Cld                        ;forward direction on move below
     Push SS                    ;point ES at SS for move DS:SI -> ES:DI
     Pop  ES
     Rep  MovSb                 ;move 4 bytes
@@:
     Mov  DX,SS                 ;send seg and address back to VB
     Mov  AX,[BP+6]             ;get dummy address from VB
     RestESDISI                 ;restore variables
     WinEpilog
     Ret 6
CVS  EndP

;----- Currency and Doubles
CVC  Proc Far                   ;Export
CVD  Proc Far                   ;Export
     WinProlog
     SaveESDISI                 ;save ES,DI,SI macro
     Lds  SI,[BP+8]             ;get address of string into DS:SI
     Push DS                    ;push it to get length
     Push SI
     Call VBGetHLStrLen         ;check the length
     Mov  CX,AX                 ;save it in case it's ok
     Cmp  AX,8                  ;well, is it a double's length?
     Jnz  @F                    ;no exit now
     Push DS                    ;ok, now push DS:SI to get address of data
     Push SI
     Call VBDeRefHLStr          ;get string data
     Mov  DS,DX                 ;transfer address to DS:SI
     Mov  SI,AX
     Mov  DI,[BP+6]             ;get dummy address from VB--phantom paramater
     Cld                        ;forward direction on move below
     Push SS                    ;point ES at SS for move DS:SI -> ES:DI
     Pop  ES
     Rep  MovSb                 ;move 8 bytes
@@:
     Mov  DX,SS                 ;send seg and address back to VB
     Mov  AX,[BP+6]             ;get dummy address from VB
     RestESDISI                 ;restore variables
     WinEpilog
     Ret 6
CVD  EndP
CVC  EndP

End
