/**
* name		StrTrunc -- truncate a string based on a set of trailing chars
*
* synopsis	str = StrTrunc(str, sub);
*
*		char	*str,		original string being truncated
*			*sub;		truncation-character string
*
* description	Removes each trailing character in "str" that is in "sub".
*		The string length is shortened by replacement with a null char.
*
* logic 	Obvious.
*
* returns	str = original string.
*
* modifies	External "CharASCII", temporarily.
*
* cautions	"str" and "sub" must be valid pointers.
*
* examples	Obvious.
**/

#ifndef LINT_ARGS
#define LINT_ARGS
#endif
//	#include <ffc/const.h>
//	#include <ffc/string.h>

/***/

extern	char		*StrTrunc(str, sub)

	char		*str,
			*sub;
{
register unsigned char	*s;

/*
*	set up CharASCII
*/

s = (unsigned char *)sub;
while (*s)
    CharASCII[*s++] = Null;

/*
*	truncate
*/

s = (unsigned char *)str;
while (*s)
    s++;
while (!(*s = CharASCII[*s]) && s-- > str)
    ;

/*
*	re-set CharASCII
*/

s = (unsigned char *)sub;
while (CharASCII[*s] = *s)
    s++;

return (str);
}
