DEFINT A-Z
DECLARE FUNCTION StringBreak% (Work$, Wide, Array$())

REDIM Array$(1 TO 1)                    'establish the string array

Work$ = "The quick brown fox doesn't mind getting broken down"
Work$ = Work$ + " into shorter lines at all, as you can tell."
Wide = 40
NumElements = StringBreak%(Work$, Wide, Array$())

CLS
PRINT STRING$(80, 205);                 'print a ruler
FOR X = 1 TO 8: PRINT SPC(8); STR$(X); : NEXT
FOR X = 1 TO 8: PRINT "1234567890"; : NEXT
PRINT STRING$(80, 205);

FOR X = 1 TO NumElements
  PRINT TAB(11); Array$(X)              'TAB indents the text
NEXT

FUNCTION StringBreak% (Work$, Wide, Array$()) STATIC

  Elements = LEN(Work$) \ Wide + 5      'estimate the array size
  REDIM Array$(1 TO Elements)           'establish that many elements
  Length = LEN(Work$)                   'determine this once
 
  CurEl = 1                             'start at element 1
  CurCol = 1                            'and at column 1

  DO
 
    Found = 0                           'assume we won't find a space
 
    FOR X = CurCol + Wide TO CurCol STEP -1         'search for a space
      IF MID$(Work$, X, 1) = " " OR X = Length THEN 'found one, or at end
        Array$(CurEl) = MID$(Work$, CurCol, X - CurCol - (X = Length))
        CurCol = X + 1                              'update the column
        Found = -1                                  'show we found it
        EXIT FOR                                    'done with this element
      END IF
    NEXT

    IF NOT Found THEN                               'no place to break it
      Array$(CurEl) = MID$(Work$, CurCol, Wide)     'so force a break
      CurCol = CurCol + Wide                        'update the column
    END IF

    CurEl = CurEl + 1                               'go to next element

  LOOP UNTIL CurCol >= Length                       'while there's more

  StringBreak% = CurEl - 1                          'assign the function

END FUNCTION

