// file.cpp

#include"file.h"
#include<malloc.h>
#include<memory.h>


int File::Offset(long offset)         
    {   
#if defined(_Windows)
    if(lseek(fh,offset,SEEK_SET) == -1)
        return -1;
    return 0;
#else
    return fseek(fp,offset,SEEK_SET);   
#endif
    }

#if defined(_Windows)
WORD File::ReadAt(DWORD offset, WORD size, void far *buf)
    {
    if(!Offset((long)offset))
        return Read(size,buf);
    return 0;
    }

DWORD File::ReadAt(DWORD offset, DWORD size, void far *buf)
    {
    if(!Offset((long)offset))
        return Read(size,buf);
    return 0;
    }

WORD File::Read(WORD size,void far *buf)
    {
    WORD bytesread = 0;
    _dos_read(fh,buf,size,&bytesread);
    return bytesread;
    }

DWORD File::Read(DWORD size,void far *buf)
    {
    char huge *p = (char huge *)buf;
    DWORD totalbytesread = 0L;
    WORD bytesread;

    while(TRUE)
        {
        if(size >= 0x0000ffff)
            {
            bytesread = Read((WORD)0xffff,p);
            totalbytesread += bytesread;
            if(bytesread < (WORD)0xffff)
                return totalbytesread;
            p += (WORD)0xffff;
            size -= (WORD)0xffff;
            if(size == 0L)
                return totalbytesread;
            }
        else
            {
            bytesread = Read((WORD)size,p);
            totalbytesread += bytesread;
            return totalbytesread;
            }
        }
    }

WORD File::WriteAt(DWORD offset, WORD size, void far *buf)
    {
    if(!Offset((long)offset))
        return Write(size, buf);
    return 0;
    }

DWORD File::WriteAt(DWORD offset, DWORD size, void far *buf)
    {
    if(!Offset((long)offset))
        return Write(size, buf);
    return 0;
    }

WORD File::Write(WORD size, void far *buf)
    {
#ifdef OLD
    int byteswritten = _lwrite(fh,(char far *)buf,size);
    return byteswritten;
#else
    WORD byteswritten = 0;
    _dos_write(fh,buf,size,&byteswritten);
    return byteswritten;
    }
#endif

DWORD File::Write(DWORD size, void far *buf)
    {
    char huge *p = (char huge *)buf;
    DWORD totalbyteswritten = 0L;
    WORD byteswritten;

    while(TRUE)
        {
        if(size >= 0x0000ffffL)
            {
            byteswritten = Write((WORD)0xffff,p);
            totalbyteswritten += byteswritten;
            if(byteswritten < (DWORD)0xffff)
                return totalbyteswritten;
            p += (WORD)0xffff;
            size -= (WORD)0xffff;
            if(size == 0L)
                return totalbyteswritten;
            }
        else
            {
            byteswritten = Write((WORD)size,p);
            totalbyteswritten += byteswritten;
            return totalbyteswritten;
            }
        }
    }

#ifdef OLD
void File::Append(File& fromfile, DWORD startoffset, DWORD endoffset)
    {
    HANDLE hMem = GlobalAlloc(GHND,0xffff);
    LPSTR lpStr = GlobalLock(hMem);
    unsigned bytesread;

    while(TRUE)
        {
        if(startoffset >= endoffset)
            break;
        bytesread = fromfile.ReadAt(startoffset,
            (((endoffset-startoffset) > 0xffff) ? (DWORD)0xffff : (endoffset-startoffset)),
            lpStr);
        if(bytesread == 0)
            break;
        Eof();
        Write((DWORD)bytesread,lpStr);
        startoffset += bytesread;
        }
    GlobalUnlock(hMem);
    GlobalFree(hMem);
    }
#else
void File::Append(File& fromfile, DWORD startoffset, DWORD endoffset, 
    LPSTR buffer)
    {
    HANDLE hMem;
    BOOL selfalloc = FALSE;
    if(buffer == NULL)
        {
        hMem = GlobalAlloc(GHND,0xffff);
        buffer = GlobalLock(hMem);
        selfalloc = TRUE;
        }
    unsigned bytesread;

    while(TRUE)
        {
        if(startoffset >= endoffset)
            break;
        bytesread = fromfile.ReadAt(startoffset,
            (((endoffset-startoffset) > 0xffff) ? (DWORD)0xffff : (endoffset-startoffset)),
            buffer);
        if(bytesread == 0)
            break;
        Eof();
        Write((DWORD)bytesread,buffer);
        startoffset += bytesread;
        }

    if(selfalloc)
        {
        GlobalUnlock(hMem);
        GlobalFree(hMem);
        }
    }
#endif


//void File::CopyBytesUpdate(DWORD& dest, DWORD source, DWORD size)

void File::CopyBytes(DWORD dest, DWORD source, DWORD size)
    {
    HANDLE hMem = GlobalAlloc(GHND,size);
    LPSTR lpStr = GlobalLock(hMem);
    unsigned bytesread;
    
    if(bytesread = ReadAt(source,size,lpStr))
        WriteAt(dest,(DWORD)bytesread,lpStr);
    GlobalUnlock(hMem);
    GlobalFree(hMem);
    }
   
int File::Create(int attrib)
    {
    if((fh = _lcreat(name,attrib)) == -1)
        return FALSE;
    return TRUE;
    }
        
int File::Open(WORD m)
    {
    if(!name)
        return FALSE;
    mode = m;

    if((fh = _lopen(name,mode)) == -1)
        return FALSE;
    return TRUE;
    }

#else

int File::ReadAt(long offset, int size, void *buf)
    {
    if(!Offset(offset))
        return Read(size,buf);
    return 0;
    }

int File::Read(int size,void *buf)
    {
    return fread(buf,1,size,fp);
    }

int File::_fRead(int size, void far *farbuf, char *nearbuf)
    {
    if(!nearbuf)
        return 0;
    int bytesread = Read(size,nearbuf);
    _fmemcpy(farbuf,nearbuf,bytesread);
    return bytesread;
    }

int File::WriteAt(long offset, int size, void *buf)
    {
    if(!Offset(offset))
        return Write(size, buf);
    return 0;
    }


int File::Write(int size, void *buf)
    {
    return fwrite(buf,1,size,fp);
    }

int File::_fWrite(int size, void far *farbuf, char *nearbuf)
    {
    if(!nearbuf)
        return 0;
    _fmemcpy(nearbuf,farbuf,size);
    int byteswritten = Write(size,(void *)nearbuf);
    return byteswritten;
    }
int File::Open(char *m)
    {
    if(!name)
        return FALSE;
    strcpy(mode,m);

    if(!(fp = fopen(name,mode)))
        return FALSE;
    return TRUE;
    }


int File::Move(char *movedir)
    {
    if(!movedir || !*movedir)
        return 1;

    char *p;
    char *newname = NULL;

    if(p = strrchr(name,'\\'))
        p++;
    else
        p = name;
    newname = new char[strlen(movedir)+strlen(p)+2];
    strcpy(newname,movedir);
    strcat(newname,"\\");
    strcat(newname,p);

    int isopen = FALSE;
    char *oldmode;
    if(fp)
        {
        isopen = TRUE;
        oldmode = new char[strlen(mode)+1];
        strcpy(oldmode,mode);
        }

    Close();

    int retval;
    if(retval = rename(name,newname))  // fall thru to no more
        {
        printf("Unable to rename %s to %s...press <RETURN>\n",
            name,newname);
        char c;
        cin >> c;
        }
    else
        SetName(newname);
    if(isopen)
        {
        Open(oldmode);
        delete oldmode;
        }
    if(newname)
        delete newname;
    return retval;
    }

char *File::GetLine(void)
    {
    InitLineBuffer();
    return fgets(linebuffer,linelen-1,fp);
    }
    
int File::Copy(char *destination)
    {
    int retval = 0;

//#if defined(NOTYET)
    if(!destination || !*destination)
        return 1;

//   char *buffer = (char *) malloc(MAXBUF);
    char *buffer = new char[MAXBUF];
    if(!buffer)
        return 1;

    File oldf(name);
    File newf(destination);

    if(!oldf.Open("rb") || !newf.Open("wb")) 
        {
        delete buffer;
        cout << "Unable to open source or destination file\n";
        return 1;
        }

    int num;
    while(num = oldf.Read(MAXBUF,buffer))
        newf.Write(num,(void *)buffer);
    newf.Close();
    oldf.Close();
//#endif
  delete buffer;
//    free(buffer);
    return retval;
    }

#endif

long File::Size(void)
    {
#if defined(_Windows)
    if(fh)
        return filelength(fh);
#else
    if(fp)
        return filelength(fileno(fp));
#endif
    FindFile f(name,ALL_FILES);
    if(f.Found())
        return f.Size();
    return 0L;
    }

int File::Delete(void)
    {
#if defined(_Windows)
    if(fh)
#else
    if(fp)
#endif
        Close();
    return remove(name);
    }


void File::Close(void)             
    {   
#if defined(_Windows)
    if(fh)
        {
        _lclose(fh);
        fh = 0;
        }
#else
    if(fp)
        {
        fclose(fp);
        fp = NULL;
        }
#endif
    }


void File::SetName(char *newname)    
    {
    if(name)
        delete name;
    name = new char[strlen(newname)+1];
    strcpy(name,newname);
    }

File::~File(void)
    {
    Close();
    if(linebuffer)
        {
        delete linebuffer;
        linebuffer = NULL;
        }
    if(name)
        {
        delete name;
        name = NULL;
        }
    }

File::File(char *newname)         
    {   
    Init();
    SetName(newname);   
    }

void File::Init(void)
    {
    linelen = DEFAULTLINELEN;
    linebuffer  = NULL;
    name = NULL;
    MAXBUF = 20000;
#if defined(_Windows)
    fh = 0;
    mode = 0;
#else
    fp = NULL;
    *mode = NULL;
#endif
    }

void File::InitLineBuffer(void)
    {
    if(!linebuffer)
        linebuffer = new char[linelen];
    }

void File::SetLineBuffer(void)
    {
    if(linebuffer)
        delete linebuffer;
    linebuffer = NULL;
    InitLineBuffer();
    }
