/* 
TESTCLIP.C -- throw-away test program for Windows clipboard API

Copyright (c) 1992 Ziff Davis Communications
PC Magazine * Andrew Schulman (June 1992)
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include "winclip.h"

static int clip_open = 0;

void fail(char *s)
{
    if (clip_open)
        CloseClipboard();
    puts(s);
    exit(1);
}

main()
{
    unsigned long len;
    char far *buf;

    if (! IdentifyWinOldApVersion())
        fail("This program must run in a DOS box "
             "under Enhanced mode Windows");

    /* MUST do OpenClipboard before GetClipboardDataSize */
    if (! OpenClipboard())
        fail("Can't open clipboard -- try again later");
    clip_open = 1;

    if ((len = GetClipboardDataSize(CF_TEXT)) == 0)
        fail("No text in clipboard");

    /* printf("%lu bytes of text in clipboard\n", len); */

    /* the following can be removed in 32-bit code */
    if (len > 0xFFF0UL)
        fail("Sorry, can't handle more than 64k of text");

    if ((buf = _fmalloc(len+1)) == 0) /* add 1 for NULL terminate */
        fail("Insufficient memory");

    if (! GetClipboardData(CF_TEXT, buf))
        fail("Couldn't get clipboard text");

    /* finally, we've got our text */
    CloseClipboard();      /* close it BEFORE displaying string */
    buf[len] = '\0';       /* add NULL terminate */
    printf("%Fs\n", buf);  /* print FAR string */
    return 0;
}

