PROGRAM renver;
USES Dos;
VAR
  f1Path, f2Path : pathStr;
  f1Dir,  f2Dir  : dirStr;
  f1Name, f2Name : nameStr;
  f1Ext,  f2Ext  : extStr;
  f              : File;
  version        : Integer;
  verStr         : String;

  PROCEDURE doHelp;
  { Display help. }
  BEGIN
    WriteLn('Rename file file1 to file2.nnn, where ',
            'nnn is the latest version');
    WriteLn('from 001 through 999.');
    WriteLn;
    WriteLn('Usage: renver [path]file1 [file2]');
    WriteLn;
    WriteLn('  path      Path to file1. Default = ',
            'current directory');
    WriteLn;
    WriteLn('  file1     File to rename');
    WriteLn;
    WriteLn('  file2     New name (no path or ',
            'extension) for file');
    WriteLn('            Default = file1 less extension.');
    WriteLn;
    WriteLn('The path containing file1 is searched for ',
            'file2.nnn for the');
    WriteLn('largest version number nnn.  If no file ',
            'exists as file2.nnn, file1 is');
    WriteLn('renamed to file2.001, otherwise file1 is renamed ',
            'to file2.nnn+1.');
    WriteLn;
    WriteLn('E.g.   renver myfile.tmp');
    WriteLn;
    WriteLn('renames myfile.tmp to myfile.003 if ',
            'the last myfile.nnn is myfile.002.');
  END;

  FUNCTION init : Boolean;
  { Get file names from command line.
    Return false if neither exists. }
  BEGIN
    init := FALSE;
    IF ParamCount = 0 THEN Exit;
    f1Path := paramStr(1);
    f2Path := paramStr(2);
    if f2Path = '' then f2Path := f1Path;
    init := TRUE;
  END;

  FUNCTION maxVersion (fPath : pathStr): integer;
  { Find max version nnn.  Return 0 if no
    file exists as file.nnn. }
  VAR
    fDir  : dirStr;
    fName : nameStr;
    fExt  : extStr;
    fRec  : searchRec;
    maxVer, ver, err : integer;
  BEGIN
    maxVer := 0;
    fSplit(fPath, fDir, fName, fExt);
    fPath := fDir + fName + '.*';
    findFirst (fPath, AnyFile, fRec);
    WHILE dosError = 0 DO
      BEGIN
        fSplit(fRec.name, fDir, fName, fExt);
        {strip period. }
        fExt := copy(fExt, 2, length(fExt) - 1);
        val(fExt, ver, err);
        IF err = 0 THEN
          IF ver > maxVer THEN maxVer := ver;
        findNext(fRec);
      END { while };
    maxVersion := maxVer;
  END;

BEGIN
  IF init THEN
    BEGIN
      fSplit(f1Path, f1Dir, f1Name, f1Ext);
      fSplit(f2Path, f2Dir, f2Name, f2Ext);
      f2Path := f1Dir + f2Name;
      version := maxVersion(f2Path) + 1;
      {- wrap 999 to 1 -}
      IF version > 999 THEN version := 1;
      {- add 1000 to get 4 digits ... -}
      str(version + 1000, verStr);
      {- then keep last three -}
      delete(verStr, 1, length(verStr) - 3); 
      WriteLn('rename ' + f1Path + ' ' +
        f2Name + '.' + verStr);
      Assign(F, f1Path);
      {$I-}Reset(F);{$I+}
      IF IOresult <> 0 THEN
        WriteLn(^G,'File ', f1Path,' does not exist.')
      ELSE
        BEGIN
          Close(F);
          Rename(F, f2Name + '.' + verStr);
        END;
    END
  ELSE doHelp;
END.

