//========================================================================
//  
//  TIME!.C -- A Timer program for Windows
//
//  (c) Douglas Boling, 1992
//
//  For better readability, set tab stops to every 3 characters.
//
//========================================================================

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "digit.h"                            //Include ctl equates

#include "Time!.h"

#define	NUMTIMERS   3
#define	MAXTIME     3600
#define	NUMDIGITS   4
 
//------------------------------------------------------------------------
//Function prototypes
//------------------------------------------------------------------------
int	PASCAL 		WinMain (HANDLE, HANDLE, LPSTR, int);
long	FAR PASCAL	WndProc (HWND, WORD, WORD, LONG);

struct TIMERSTRUCT {
	BOOL	bRunning;
	int	sValue;
	DWORD	dwStart;	
} tsTimer [NUMTIMERS];

char		szAppName[] = "Time!";
char		szProfileName[] = "TIME!.INI";
HANDLE  	hInst;

//=======================================================================
//
// Program Entry Point (WinMain)
//
//=======================================================================
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	            LPSTR lpszCmdParam, int nCmdShow) {

   HWND			hwnd;
	HANDLE		hAccel, hLibInst;
   MSG			msg;
   WNDCLASS		wndclass;
	int			i, j;

	if (!hPrevInstance) {
      wndclass.style          = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc    = (FARPROC) WndProc;
      wndclass.cbClsExtra     = 0;
      wndclass.cbWndExtra     = DLGWINDOWEXTRA;
      wndclass.hInstance      = hInstance;
      wndclass.hIcon          = LoadIcon (hInstance, szAppName);
      wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground  = COLOR_WINDOW + 1;
      wndclass.lpszMenuName   = 0;
      wndclass.lpszClassName  = szAppName;

      RegisterClass (&wndclass);
   }
	hInst = hInstance;
	
	hLibInst = LoadLibrary ("digit.dll");
	if (hLibInst < 32) {
		MessageBox (NULL, "Unable to load DIGIT.DLL", 
		            szAppName, MB_ICONEXCLAMATION | MB_OK);
		return 1;
	}	
	hwnd = CreateDialog (hInstance, szAppName, 0, NULL);
	
	if (lpszCmdParam[0] == '/' || lpszCmdParam[0] == '-') 
		if (lpszCmdParam[1] == 'i' || lpszCmdParam[1] == 'I') 
			nCmdShow |= SW_MINIMIZE;

	i = GetPrivateProfileInt (szAppName, "x", 300, szProfileName);
	j = GetPrivateProfileInt (szAppName, "y", 100, szProfileName);

	if (GetPrivateProfileInt (szAppName, "icon", 0, szProfileName)) 
  		nCmdShow |= SW_MINIMIZE;

	SetWindowPos (hwnd, NULL, i, j, 0, 0, SWP_NOSIZE);
	ShowWindow (hwnd, nCmdShow);
	hAccel = LoadAccelerators (hInstance, szAppName);

	while (GetMessage (&msg, NULL, 0, 0)) {
	   if (hwnd == 0 || !IsDialogMessage (hwnd, &msg))
			if (!TranslateAccelerator (hwnd, hAccel, &msg)) {
			   TranslateMessage (&msg);
	   		DispatchMessage (&msg);
			}
	}
	FreeLibrary (hLibInst);
   return msg.wParam;
}

//	   if (hwnd == 0 || !IsDialogMessage (hwnd, &msg))

//========================================================================
//
// Routines used by WndProc
//
//========================================================================

//------------------------------------------------------------------------
// About box dialog procedure
//------------------------------------------------------------------------
BOOL FAR PASCAL AboutDlgProc (HWND hwnd, WORD message, WORD wParam, 
                               LONG lParam) {
	switch (message) {

		case WM_COMMAND:
			switch (wParam) {

				case IDOK:
					EndDialog (hwnd, 1);
					return TRUE;
			}
			break;

		case WM_CLOSE:
			EndDialog (hwnd, 0);
			return TRUE;
	}
	return FALSE;	
}

//------------------------------------------------------------------------
// SetDigits - Sets the digits to the value specified
//------------------------------------------------------------------------
void SetDigits (HWND hwnd, WORD wValue) {

	WORD	wRemainder;
	BOOL	bNoBlank;

	bNoBlank = FALSE;
	wRemainder = wValue / 600;
	if (wRemainder) {
		SendDlgItemMessage (hwnd, IDD_TMINDIG, DIGM_BLANK, FALSE, 0);
		wValue -= wRemainder * 600;
		bNoBlank = TRUE;
	} else 
		SendDlgItemMessage (hwnd, IDD_TMINDIG, DIGM_BLANK, TRUE, 0);

	SendDlgItemMessage (hwnd, IDD_TMINDIG, DIGM_SET, wRemainder, 0);

	wRemainder = wValue / 60;
	if (wRemainder || bNoBlank) {
		SendDlgItemMessage (hwnd, IDD_MINDIG, DIGM_BLANK, FALSE, 0);
		wValue -= wRemainder * 60;
	} else
		SendDlgItemMessage (hwnd, IDD_MINDIG, DIGM_BLANK, TRUE, 0);

	SendDlgItemMessage (hwnd, IDD_MINDIG, DIGM_SET, wRemainder, 0);

	wRemainder = wValue / 10;
	if (wRemainder)
		wValue -= wRemainder * 10;

	SendDlgItemMessage (hwnd, IDD_TSECDIG, DIGM_SET, wRemainder, 0);

	SendDlgItemMessage (hwnd, IDD_SECDIG, DIGM_SET, wValue, 0);

	return;
}

//------------------------------------------------------------------------
// GetDigits - Gets the value loaded in the digit controls
//------------------------------------------------------------------------
int GetDigits (HWND hwnd) {

	WORD	sValue;

	sValue =  600 * (int) SendDlgItemMessage (hwnd, IDD_TMINDIG, 
	                                          DIGM_GET, 0, 0);
	sValue +=  60 * SendDlgItemMessage (hwnd, IDD_MINDIG, DIGM_GET, 0, 0);
	sValue +=  10 * SendDlgItemMessage (hwnd, IDD_TSECDIG, DIGM_GET, 0, 0);
	sValue +=       SendDlgItemMessage (hwnd, IDD_SECDIG, DIGM_GET, 0, 0);

	return sValue;
}

//------------------------------------------------------------------------
// Sounds the alarm for a timer.
//------------------------------------------------------------------------
void SoundAlarm (void) {
	MessageBeep (30);
}
//------------------------------------------------------------------------
// Sets the proper state for each of the buttons
//------------------------------------------------------------------------
void SetButtons (HWND hwnd, BOOL bRunning, WORD wOTimer, WORD wTimer) {

	if (wOTimer != 0xFFFF) 
		ShowWindow (GetDlgItem (hwnd, IDD_MTIME1 + wOTimer), SW_HIDE);

	ShowWindow (GetDlgItem (hwnd, IDD_MTIME1 + wTimer), SW_SHOW);

	if (bRunning) {
		SetDlgItemText (hwnd, IDD_GO, "S&top");
		EnableWindow (GetDlgItem (hwnd, IDD_BMINUTES), FALSE);
		EnableWindow (GetDlgItem (hwnd, IDD_BSECONDS), FALSE);
	} else {
		SetDlgItemText (hwnd, IDD_GO, "S&tart");
		EnableWindow (GetDlgItem (hwnd, IDD_BMINUTES), TRUE);
		EnableWindow (GetDlgItem (hwnd, IDD_BSECONDS), TRUE);
	}

}

//------------------------------------------------------------------------
// Computes the time remaining for a timer
//------------------------------------------------------------------------
int ComputeTime (DWORD dwCurrentTime, DWORD dwStart, int sValue) {

	DWORD dwTemp;

	dwTemp = (dwCurrentTime - dwStart);

	return sValue - (int) dwTemp;
}				

//========================================================================
//
// Main Window Procedure.
//
//========================================================================
long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam) {

	static	int	sSelTimer, sActiveTimers;	
	static	BOOL	bFirst;
	int		i, sTime;
	DWORD		dwTemp, dwCurrTime;
	char		szTemp[10];
	RECT		rect;

   switch (message) {

      case WM_CREATE:      	
			for (i = 0; i < NUMTIMERS; i++) {
				tsTimer[i].bRunning = FALSE;
				tsTimer[i].sValue = 0;
				tsTimer[i].dwStart = 0;
			}
			bFirst = TRUE;
			sActiveTimers = 0;
			sSelTimer = 0;
	 		return 0;

		case WM_SIZE:
			if (bFirst) {

				if (GetPrivateProfileInt (szAppName, "LCD", 0, szProfileName)) 
					for (i = 0; i < NUMDIGITS; i++) {
						dwTemp = GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
						                        GWL_STYLE);
						SetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
					                  GWL_STYLE, dwTemp & ~DIGS_LED);
					}
				//
				//Set proper base for each digit
				//
				SendDlgItemMessage (hwnd, IDD_SECDIG, DIGM_SETBASE, 10, 0);
				SendDlgItemMessage (hwnd, IDD_TSECDIG, DIGM_SETBASE, 6, 0);
				SendDlgItemMessage (hwnd, IDD_MINDIG, DIGM_SETBASE, 10, 0);
				SendDlgItemMessage (hwnd, IDD_TMINDIG, DIGM_SETBASE, 6, 0);
				//
				//Set Timer 1 active
				//
				ShowWindow (GetDlgItem (hwnd, IDD_MTIME2), SW_HIDE);
				ShowWindow (GetDlgItem (hwnd, IDD_MTIME3), SW_HIDE);
				SetButtons (hwnd, FALSE, -1, sSelTimer);
				SetDigits (hwnd, 0);

				SetFocus (GetDlgItem (hwnd, IDD_GO));

				bFirst = FALSE;
			}
			break;

		case WM_TIMER:

			time (&dwCurrTime);
			for (i = 0; i < NUMTIMERS; i++) {
				if (tsTimer[i].bRunning) {
			
					sTime = ComputeTime (dwCurrTime, tsTimer[i].dwStart,
					                     tsTimer[i].sValue);
				
					if (sTime <= 0) {
						sTime = 0;
						tsTimer[i].sValue = 0;
						tsTimer[i].bRunning = FALSE;
						SoundAlarm ();
						SetActiveWindow (hwnd);
						sActiveTimers--;
						if (i == sSelTimer) 
							SetButtons (hwnd, FALSE, i, sSelTimer);
					}
					if (i == sSelTimer) 
						SetDigits (hwnd, sTime);
				}
			}
			if (sActiveTimers == 0) KillTimer (hwnd, 1);
			break;

		case WM_COMMAND:
			switch (wParam) {
				//
				// DigitClass control messages
				//
				case IDD_SECDIG:
				case IDD_TSECDIG:
				case IDD_MINDIG:
				case IDD_TMINDIG:
					switch (HIWORD (lParam)) {

						case DIGN_CARRY:
							if (wParam != IDD_TMINDIG) 
								SendDlgItemMessage (hwnd, wParam+1, DIGM_INC, 0, 0);
							break;

						case DIGN_BORROW:
							if (wParam != IDD_TMINDIG) { 
								SendDlgItemMessage (hwnd, wParam+1, DIGM_DEC, 0, 0);
								dwTemp = GetWindowLong (GetDlgItem (hwnd, wParam+1),
								                        GWL_STYLE);
								if (dwTemp & DIGS_BLANK)
									SendDlgItemMessage (hwnd, wParam+1, DIGM_BLANK,
									                    FALSE, 0);
							}
							break;

						case DIGN_RCLICK:
						case DIGN_LCLICK:
							if (!tsTimer[sSelTimer].bRunning) {

								if (HIWORD (lParam) == DIGN_LCLICK) {
									i = (int) SendDlgItemMessage (hwnd, wParam, 
									                              DIGM_GET, 0, 0);
									if (++i == (int) SendDlgItemMessage (hwnd, wParam, 
									                                 DIGM_GETBASE, 
																				0, 0))
										i = 0;
								} else {
									i = (int) SendDlgItemMessage (hwnd, wParam, 
									                              DIGM_GET, 0, 0);
									if (i-- == 0) i = 10;
								}
								SendDlgItemMessage (hwnd, wParam, DIGM_SET, 
								                    i, 0);

								if (wParam == IDD_TMINDIG && i == 0) {
									SendDlgItemMessage (hwnd, IDD_TMINDIG, 									                    DIGM_BLANK, TRUE, 0);
								}

								if (wParam == IDD_MINDIG && i == 0) {
									if (DIGS_BLANK & GetWindowLong (
									                        GetDlgItem (hwnd, 
																	            IDD_TMINDIG),
									                        GWL_STYLE))
										SendDlgItemMessage (hwnd, IDD_MINDIG, 
										                    DIGM_BLANK, TRUE, 0);
								}

								if (i != 0) {
	  								for (i = wParam; i > IDD_TSECDIG; i--) {
  										dwTemp = GetWindowLong (GetDlgItem (hwnd, i),
										                        GWL_STYLE);
										if (dwTemp & DIGS_BLANK)
											SendDlgItemMessage (hwnd, i, DIGM_BLANK,
											                    FALSE, 0);
										else
											break;
									}
								}
								tsTimer[sSelTimer].sValue = GetDigits (hwnd);
							}
							break;

					}
					break;

				//
				// Menu messages
				//
				case IDM_LED:
					dwTemp = GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG),
					                        GWL_STYLE);
					if (!(dwTemp & DIGS_LED)) {
						for (i = 0; i < NUMDIGITS; i++) {
							dwTemp = GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
							                        GWL_STYLE);
							SetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
						                  GWL_STYLE, dwTemp | DIGS_LED);
						}
						InvalidateRect (hwnd, NULL, TRUE);
					}
					return 0;

				case IDM_LCD:
					dwTemp = GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG),
					                        GWL_STYLE);
					if (dwTemp & DIGS_LED != 0) {
						for (i = 0; i < NUMDIGITS; i++) {
							dwTemp = GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
							                        GWL_STYLE);
							SetWindowLong (GetDlgItem (hwnd, IDD_SECDIG+i),
						                  GWL_STYLE, dwTemp & ~DIGS_LED);
						}
						InvalidateRect (hwnd, NULL, TRUE);
					}
					return 0;

				case IDM_ABOUT:
					{
						FARPROC	lpfnAboutDlgFn;
						lpfnAboutDlgFn = MakeProcInstance (AboutDlgProc, hInst);
						DialogBox (hInst, "About", hwnd, lpfnAboutDlgFn);
						FreeProcInstance (lpfnAboutDlgFn);
					}
					return 0;

				case IDM_EXIT:
					EndDialog (hwnd, TRUE);
					SendMessage (hwnd, WM_CLOSE, 0, 0);
					return 0;
				//
				// Button messages
				//
				case IDD_GO:
					time (&dwCurrTime);
					if (tsTimer[sSelTimer].bRunning) {
						tsTimer[sSelTimer].bRunning = FALSE;
						tsTimer[sSelTimer].sValue = ComputeTime (dwCurrTime,
						                            tsTimer[sSelTimer].dwStart,
					                               tsTimer[sSelTimer].sValue);

						if (--sActiveTimers == 0) KillTimer (hwnd, 1);
					} else {
						if (sActiveTimers++ == 0) {
							if (!SetTimer (hwnd, 1, 1000, 0L)) {
								MessageBox (hwnd, "No Available Timers", 
								            szAppName, MB_ICONEXCLAMATION | MB_OK);
								return 0;
							}
						}
						tsTimer[sSelTimer].bRunning = TRUE;
						tsTimer[sSelTimer].dwStart = dwCurrTime;
					}
					SetButtons (hwnd, tsTimer[sSelTimer].bRunning, -1, sSelTimer);
					return 0;

				case IDD_BTIMER1:
				case IDD_BTIMER2:
				case IDD_BTIMER3:
					i = wParam - IDD_BTIMER1;
					if (sSelTimer != i) {
						//
						//Get old timer value
						//
						if (!tsTimer[sSelTimer].bRunning) 
							tsTimer[sSelTimer].sValue = GetDigits (hwnd);

						SetButtons (hwnd, tsTimer[i].bRunning, sSelTimer, i);
						sSelTimer = i;

						if (tsTimer[sSelTimer].bRunning) {
							time (&dwCurrTime);
							sTime = ComputeTime (dwCurrTime, tsTimer[i].dwStart,
							                     tsTimer[i].sValue);
						} else {
							sTime = tsTimer[i].sValue;
						}
						SetDigits (hwnd, sTime);
					}
					return 0;

				case IDD_BSECONDS:
					SetDigits (hwnd, ++tsTimer[sSelTimer].sValue);					
					return 0;

				case IDD_BMINUTES:
					tsTimer[sSelTimer].sValue += 60;
					SetDigits (hwnd, tsTimer[sSelTimer].sValue);
					return 0;
			}
			break;

		case WM_DESTROY:
			if (sActiveTimers) KillTimer (hwnd, 1);
			//
			//Save values
			//
			if (GetWindowLong (GetDlgItem (hwnd, IDD_SECDIG), GWL_STYLE)
				 & DIGS_LED) 
				WritePrivateProfileString (szAppName, "LCD", "0", 
				                           szProfileName);
			else		
				WritePrivateProfileString (szAppName, "LCD", "1", 
				                           szProfileName);

			if (IsIconic (hwnd)) {
				WritePrivateProfileString (szAppName, "Icon", "1", 
				                           szProfileName);
			} else if (!IsIconic (hwnd)) {
				WritePrivateProfileString (szAppName, "Icon", "0", 
				                           szProfileName);
				GetWindowRect (hwnd, &rect);
				itoa (rect.left, szTemp, 10);
				WritePrivateProfileString (szAppName, "x", szTemp, 
				                           szProfileName);
				itoa (rect.top, szTemp, 10);
				WritePrivateProfileString (szAppName, "y", szTemp, 
				                           szProfileName);
			}
			PostQuitMessage (0);
			return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam);
}

