{$S-,B-,D-,L-}
Library Match;
{$IFNDEF Windows} ERROR: Must compile for _Windows_ target
{$ENDIF}
USES Strings;

FUNCTION Matches(S0, S1 : pChar) : Boolean; export;
CONST
  asterisk = '*';
  QMark    = '?';
  Null     = #0;
VAR
  Matching : boolean;
  Done     : boolean;
  Len      : LongInt;

BEGIN
  Matching := true;
  Done := (S0^=null) AND (S1^=null);

  WHILE NOT Done AND Matching DO
    BEGIN
      CASE S0^ OF
        QMark : BEGIN
          Matching := S1^<>null;
          IF Matching THEN
            BEGIN
              Inc(S0);
              Inc(S1)
            END;
        END;

        asterisk: BEGIN
          REPEAT Inc(S0)
          UNTIL S0^<>asterisk;

          Len := StrLen(S1);
          Inc(S1,Len);
          Matching := Matches(S0,S1);
          WHILE (Len>=0) AND NOT Matching DO
            BEGIN
              Dec(S1);
              Dec(Len);
              Matching := Matches(S0,S1)
            END;
          IF Matching THEN
            BEGIN
              S0 := StrEnd(S0);
              S1 := StrEnd(S1)
            END;
         END;

        ELSE BEGIN
          Matching := S0^=S1^;
          IF Matching THEN
            BEGIN
              Inc(S0);
              Inc(S1)
            END;
        END;
     END;

     Done := (S0^=null) and (S1^=null)
   END;

  Matches := Matching
END;

exports Matches index 1;

BEGIN
END.