Unit VerbosMB;             {By Kurt Herzog, 06/10/92 vers:10/28/92}
                           {A unit to facilitate wordy MessageBoxes}
{$IFDEF PRODUCTION}
  {$R-}                    {No range checking}
  {$S-}                    {No Stack checking}
  {$D-}                    {No debug data}
  {$L-}                    {No Local debug symbols}
{$ENDIF}
{$X+}

(**) INTERFACE (**)

USES
  Strings,                      {Nul-terminated string support}
  WinTypes,                     {All standard Windows types}
  WinProcs;                     {Defines Func/Proc headers for API}

  FUNCTION VerboseMessage
            (hParent  : HWnd;     {Parent Window handle}
             First,               {ID of first string (box title)}
             Last     : word;     {ID of last string in series}
             VAR ArgList;         {table of wvsPrintf arguments}
             mbConst  : word)     {mb_constants}
                      : integer;  {returns mb_response or -1}
                                  {if unable to allocate memory}

  (**) IMPLEMENTATION (**)

  FUNCTION VerboseMessage (hParent : HWnd; First, Last : word;
                           VAR ArgList; mbConst : word) : integer;
  TYPE
    PBuffer      = ^TBuffer;
    TBuffer      = RECORD
      Area1      : ARRAY[0..1023] OF Char; {Max size for wvsPrintf}
      Area2      : ARRAY[0..1023] OF Char;
    END;
  VAR
    WorkBuffer   : PBuffer;
    Maintext     : PChar;
    Stringnumber : word;
    Stringsize   : Integer;
  BEGIN
    GetMem(WorkBuffer,SizeOf(TBuffer));
    IF WorkBuffer = nil THEN
      BEGIN
        VerboseMessage := -1;
        Exit;
      END;
    WITH WorkBuffer^ DO
      BEGIN
        Area2[0] := Chr(0); {Init to no data}
        FOR Stringnumber := First TO Last DO
          BEGIN
            Stringsize := LoadString(HInstance, Stringnumber,
                          Area1, SizeOf(Area1)-1);
            IF Stringsize <> 0 THEN {Ignore missing string numbers}
              BEGIN
                StrLCat(Area2, Area1, SizeOf(Area2)-1);
                StrLCat(Area2, Chr(13), SizeOf(Area2)-1); {CR @ end}
              END;
          END;
        {Edit in any argument parameters}
        wvsPrintf(Area1, Area2, ArgList);
        {Replace 1st CR with null to terminate box title,}
        {then set main text pointer to data following box title}
        Maintext := StrScan(Area1, Chr(13));
        IF Maintext <> nil THEN
          BEGIN
            Maintext[0] := Chr(0);
            Maintext := @Maintext[1];
          END;
        VerboseMessage := MessageBox(hParent, Maintext, Area1,
          mbConst);
        FreeMem(WorkBuffer,SizeOf(TBuffer));
      END;
  END;

END.