/*----------------------------------------
   PATHRGN.C -- Paths and Regions
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <math.h>

#define TWOPI (2 * 3.14159)

char szClass [] = "PathRgn" ;
char szTitle [] = "PathRgn: Paths and Regions" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HBRUSH   hBrushBlue, hBrushRed ;
     HPEN     hPenBlue ;
     HRGN     hRgn ;
     INT      i, x, y, iAngle ;
     LOGBRUSH lb ;
     POINT    pt [5] ;

               // Create brushes and a pen

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (0, 0, 255) ;
     lb.lbHatch = 0 ;

     hBrushBlue = CreateBrushIndirect (&lb) ;

     hPenBlue   = ExtCreatePen (PS_GEOMETRIC | PS_SOLID, 5, &lb, 0, NULL) ;

     lb.lbStyle = BS_HATCHED ;
     lb.lbColor = RGB (255, 0, 0) ;
     lb.lbHatch = HS_DENSE1 ;

     hBrushRed  = CreateBrushIndirect (&lb) ;

               // Loop through the six figures

     for (y = 0 ; y < 2 ; y++)
          {
          SetPolyFillMode (hdc, y ? WINDING : ALTERNATE) ;

          for (x = 0 ; x < 3 ; x++)
               {
                    // Define points used for the stars

               for (i = 0 ; i < 5 ; i++)
                    {
                    iAngle = 72 * i - 90 ;

                    pt[2 * i % 5].x = (2 * x + 1) * cxArea / 6 +
                         (INT) (cxArea * .150 * cos (TWOPI * iAngle / 360)) ;

                    pt[2 * i % 5].y = (2 * y + 1) * cyArea / 4 +
                         (INT) (cyArea * .225 * sin (TWOPI * iAngle / 360)) ;
                    }

                    // Create the path

               BeginPath  (hdc) ;
               MoveToEx   (hdc, pt[0].x, pt[0].y, NULL) ;
               PolylineTo (hdc, pt + 1, 4) ;
               CloseFigure (hdc) ;
               EndPath (hdc) ;

                    // Render the path

               switch (x)
                    {
                    case 0:
                         SelectObject (hdc, GetStockObject (BLACK_PEN)) ;
                         StrokePath (hdc) ;
                         break ;

                    case 1:
                         SelectObject (hdc, hPenBlue) ;
                         SelectObject (hdc, hBrushRed) ;
                         StrokeAndFillPath (hdc) ;
                         break ;

                    case 2:
                         hRgn = PathToRegion (hdc) ;

                         FillRgn  (hdc, hRgn, hBrushRed) ;
                         FrameRgn (hdc, hRgn, hBrushBlue, 5, 5) ;

                         DeleteObject (hRgn) ;
                         break ;
                    }
               }
          }

     SelectObject (hdc, GetStockObject (BLACK_PEN)) ;
     SelectObject (hdc, GetStockObject (WHITE_BRUSH)) ;

     DeleteObject (hBrushRed) ;
     DeleteObject (hBrushBlue) ;
     DeleteObject (hPenBlue) ;
     }
