/*-----------------------------------------
   PATHRGN2.C -- Paths and Regions
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>

char szClass [] = "PathRgn2" ;
char szTitle [] = "PathRgn2: Paths and Regions" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HRGN hRgn ;
     SIZE size ;

          // Set logical coordinates to 5 times device coordinates

     SetMapMode (hdc, MM_ANISOTROPIC) ;

     GetWindowExtEx (hdc, &size) ;
     SetWindowExtEx (hdc, 5 * size.cx, 5 * size.cy, NULL) ;

          // Create a 500-unit wide rectangle path and stroke it

     BeginPath (hdc) ;
     Rectangle (hdc, 500, 500, 1000, 1000) ;
     EndPath (hdc) ;

     StrokePath (hdc) ;

          // Create the same path, convert to region, and fill it

     BeginPath (hdc) ;
     Rectangle (hdc, 500, 500, 1000, 1000) ;
     EndPath (hdc) ;

     hRgn = PathToRegion (hdc) ;

     FillRgn (hdc, hRgn, GetStockObject (BLACK_BRUSH)) ;

     DeleteObject (hRgn) ;
     }
