/*----------------------------------------
   EZTEST5.C -- EZFONT Test Program # 5
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "EzTest5" ;
char szTitle [] = "EzTest5:  EZFONT Test Program # 5" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static INT iDeciPtHeight    = 180,
                iDeciPtWidth [4] = { 0, 180, 90, 360 } ;
     CHAR       szBuffer [64] ;
     HFONT      hFont ;
     INT        i, y ;
     TEXTMETRIC tm ;

     SetBkMode (hdc, TRANSPARENT) ;

     y = 0 ;

     for (i = 0 ; i < 4 ; i++)
          {
          hFont = EzCreateFont (hdc, "Times New Roman Bold",
                                iDeciPtHeight, iDeciPtWidth [i], 0, TRUE) ;

          SelectObject (hdc, hFont) ;
          GetTextMetrics (hdc, &tm) ;

          wsprintf (szBuffer, "Font Height: %d.%d, Width: %d.%d",
                    iDeciPtHeight    / 10, iDeciPtHeight    % 10,
                    iDeciPtWidth [i] / 10, iDeciPtWidth [i] % 10) ;

          TextOut (hdc, 0, y, szBuffer, strlen (szBuffer)) ;

          SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
          DeleteObject (hFont) ;

          y += tm.tmHeight - tm.tmInternalLeading ;
          }
     }
