
***********************************************************************
* GENCRT.PRG                                        FoxPro for Windows
* Program that constructs the text for a CREATE TABLE command
* based upon the currently open table, placing it into the
* clipboard for insertion into a program.
*
* Usage: DO GENCRT or DO GENCRT WITH "TABLNAME"
***********************************************************************
PARAMETER cDBF                  && Passed table name if any
IF SET("TALK") = "ON"           && Set and save TALK setting
   SET TALK OFF
   m.talkstat = "ON"
ELSE
   m.talkstat = "OFF"
ENDIF
m.workarea = SELECT()           && Save work area
IF !EMPTY(cDBF)                 && If parameter is passed
   IF USED(cDBF)                && If table is in use
      SELECT (cDBF)             && Select that work area
   ELSE                         && else
      SELECT 0                  && Select an open work area
      USE (cDBF)                && and open the requested table
   ENDIF
ENDIF
IF USED()                       && as long as we have a table

   _CLIPTEXT = "CREATE TABLE " + LOWER(DBF()) + " ("
   =AFIELDS(aFlds)              && populate array with table structure

   * Array Contents  Index
   * -------------- --------
   * Field name        1
   * Field type        2
   * Length            3
   * Precision         4

   * Loop through each row in the array and add the
   * field details to the command

   FOR x = 1 TO ALEN(aFlds, 1)
      _CLIPTEXT = _CLIPTEXT + ;
      LOWER(aFlds(x,1)) + ;
      " " + ;
      aFlds(x,2) + ;
      "(" + ;
      LTRIM(STR(aFlds(x,3))) + ;
      IIF(NOT EMPTY(aFlds(x,4)), ;
      ","+LTRIM(STR(aFlds(x,4))), "") + ;
      ")" + ;
      IIF(ALEN(aFlds,1)<>x,", ","")
   ENDFOR

   _CLIPTEXT = _CLIPTEXT + ")"
ELSE
   WAIT WINDOW NOWAIT "No database in use in this work area"
ENDIF
IF m.talkstat = "ON"
   SET TALK ON
ENDIF
SELECT (m.workarea)             && restore the original work area
RETURN
