#define IDD_LISTBOX     100

DEFINE_GUID (CLSID_ShellExtension, 0x8e3e0f0a, 0x0fcc, 0x11ce, 0xbc, 0xb0,
    0xb3, 0xfd, 0x0e, 0x25, 0x38, 0x20);

//
// CClassFactory defines a shell extension class factory object.
//
class CClassFactory : public IClassFactory
{
protected:
    ULONG   m_cRef;         // Object reference count
    
public:
    CClassFactory ();
    ~CClassFactory ();
        
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID FAR *);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IClassFactory methods
    STDMETHODIMP    CreateInstance (LPUNKNOWN, REFIID, LPVOID FAR *);
    STDMETHODIMP    LockServer (BOOL);
};

//
// CShellExtension defines a property sheet shell extension object.
//
class CShellExtension : public IShellPropSheetExt, IShellExtInit
{
protected:
    ULONG           m_cRef;                 // Object reference count
    char            m_szFile[MAX_PATH];     // EXE file name

    BOOL            IsPEFile (char *);

public:
    CShellExtension ();
    ~CShellExtension ();
    
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID FAR *);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IShellPropSheetExt methods
    STDMETHODIMP    AddPages (LPFNADDPROPSHEETPAGE lpfnAddPage, LPARAM lParam);
    STDMETHODIMP    ReplacePage (UINT uPageID,
                        LPFNADDPROPSHEETPAGE lpfnReplaceWith, LPARAM lParam);

    // IShellExtInit method
    STDMETHODIMP    Initialize (LPCITEMIDLIST pidlFolder,
                        LPDATAOBJECT lpdobj, HKEY hKeyProgID);
};
