/*
   HELPDLL.H -- Definitions for WinHelp DLLs
   Includes Microsoft-supplied DLL.H

   Copyright 1994, Jim Mischel
*/
#include "dll.h"

// Undocumented message sent to DLLs
#define DW_ACTIVATEWIN 11

// Undocumented callback function offsets
#define HE_FChSizeHF        17
#define HE_HFCreateFileHFS  18
#define HE_RCUnlinkFileHFS  19
#define HE_RCFlushHF        20
#define HE_LCBWriteHF       21
#define HE_RCRenameFileHFS  22
#define HE_RCAbandonHF      23
#define HE_HFSCreateFileSys 24
#define HE_RCDestroyFileSys 25
#define HE_Last             26

#define VPTR_Size (HE_Last * sizeof (VPTR))

// Type definitions for undocumented callbacks
typedef BOOL (FAR PASCAL *LPFN_FCHSIZEHF)(HF f, LONG qlSize);
typedef HF (FAR PASCAL *LPFN_HFCREATEFILEHFS)
         (HFS fs, LPSTR szName, BYTE bFlags);
typedef RC (FAR PASCAL *LPFN_RCUNLINKFILEHFS)(HFS fs, LPSTR szName);
typedef RC (FAR PASCAL *LPFN_RCFLUSHHF)(HF f);
typedef LONG (FAR PASCAL *LPFN_LCBWRITEHF)
         (HF f, LPBYTE qb, LONG LCB);
typedef RC (FAR PASCAL *LPFN_RCRENAMEFILEHFS)
         (HFS fs, LPSTR szOldName, LPSTR szNewName);
typedef RC (FAR PASCAL *LPFN_RCABANDONHF)(HF f);
typedef HFS (FAR PASCAL *LPFN_HFSCREATEFILESYS)
         (LPSTR szName, LONG Something);
typedef RC (FAR PASCAL *LPFN_RCDESTROYFILESYS)(LPSTR szName);

// DLL items structure
typedef struct tagwhDLLStruc {
  unsigned StackSeg;          // unique instance identifier
  VPTR FPtrs;                 // table of callback functions
  void far * Extra;           // DLL-specific instance data
  struct tagwhDLLStruc *Next; // pointer to next item in list
} whDLLStruc, far * whDLLPtr;

typedef void (far *whDLLFreeFunc)(void far *p);

// functions defined in HELPDLL.C
BOOL far pascal GetWinHelpCallbacks (VPTR VPtr, long lVersion);
void far pascal EndWinHelpDLL (whDLLFreeFunc Func);
whDLLPtr far pascal GetCurrentModule (void);

#define CreateDLLInstance GetCurrentModule

// WinHelp callback function macros
#define HFSOpenSz(szName, fMode) \
  ((LPFN_HFSOPENSZ)(GetCurrentModule())->FPtrs[HE_HfsOpenSz]) \
  (szName, fMode)
#define RCCloseHFS(fs) \
  ((LPFN_RCCLOSEHFS)(GetCurrentModule())->FPtrs[HE_RcCloseHfs]) \
  (fs)
#define HFOpenHFS(fs, szName, bFlags) \
  ((LPFN_HFOPENHFS)(GetCurrentModule())->FPtrs[HE_HfOpenHfs]) \
  (fs, szName, bFlags)
#define RCCloseHF(f) \
  ((LPFN_RCCLOSEHF)(GetCurrentModule())->FPtrs[HE_RcCloseHf])(f)
#define LCBReadHF(f, qb, LCB) \
  ((LPFN_LCBREADHF)(GetCurrentModule())->FPtrs[HE_LcbReadHf]) \
  (f, qb, LCB)
#define LTellHF(f) \
  ((LPFN_LTELLHF)(GetCurrentModule())->FPtrs[HE_LTellHf])(f)
#define LSeekHF(f, lOffset, wOrigin) \
  ((LPFN_LSEEKHF)(GetCurrentModule())->FPtrs[HE_LSeekHf]) \
  (f, lOffset, wOrigin)
#define FEofHF(f) \
  ((LPFN_FEOFHF)(GetCurrentModule())->FPtrs[HE_FEofHf])(f)
#define LCBSizeHF(f) \
  ((LPFN_LCBSIZEHF)(GetCurrentModule())->FPtrs[HE_LcbSizeHf])(f)
#define FAccessHFS(fs, szName, bFlags) \
  ((LPFN_FACCESSHFS)(GetCurrentModule())->FPtrs[HE_FAccessHfs]) \
  (fs, szName, bFlags)
#define ErrorW(nError) \
  ((LPFN_ERRORW)(GetCurrentModule())->FPtrs[HE_ErrorW])(nError)
#define ErrorSz(ErrMsg) \
  ((LPFN_ERRORSZ)(GetCurrentModule())->FPtrs[HE_ErrorSz])(ErrMsg)
#define LGetInfo(wItem, hwnd) \
  ((LPFN_LGETINFO)(GetCurrentModule())->FPtrs[HE_GetInfo]) \
  (wItem, hwnd)
#define FApi(qchHelp, wCommand, ulData) \
  ((LPFN_FAPI)(GetCurrentModule())->FPtrs[HE_FAPI]) \
  (qchHelp, wCommand, ulData)
#define RCLLInfoFromHF(f, wOption, qFid, qlBase, qLCB) \
  ((LPFN_RCLLINFOFROMHF) \
  (GetCurrentModule())->FPtrs[HE_RcLLInfoFromHf]) \
  (f, wOption, qFid, qlBase, qLCB)
#define RCLLInfoFromHFS(fs, szName, wOption, qFid, qlBase, qLCB) \
  ((LPFN_RCLLINFOFROMHFS) \
  (GetCurrentModule())->FPtrs[HE_RcLLInfoFromHfs]) \
  (fs, szName, wOption, qFid, qlBase, qLCB)
#define FChSizeHF(f, qlSize) \
  ((LPFN_FCHSIZEHF)(GetCurrentModule())->FPtrs[HE_FChSizeHF]) \
  (f, qlSize)
#define HFCreateFileHFS(fs, szName, bFlags) \
  ((LPFN_HFCREATEFILEHFS) \
  (GetCurrentModule())->FPtrs[HE_HFCreateFileHFS]) \
  (fs, szName, bFlags)
#define RCUnlinkFileHFS(fs, szName) \
  ((LPFN_RCUNLINKFILEHFS) \
  (GetCurrentModule())->FPtrs[HE_RCUnlinkFileHFS])(fs, szName)
#define RCFlushHF(f) \
  ((LPFN_RCFLUSHHF)(GetCurrentModule())->FPtrs[HE_RCFlushHF])(f)
#define LCBWriteHF(f, qb, LCB) \
  ((LPFN_LCBWRITEHF) \
  (GetCurrentModule())->FPtrs[HE_LCBWriteHF])(f, qb, LCB)
#define RCRenameFileHFS(fs, szOldName, szNewName) \
  ((LPFN_RCRENAMEFILEHFS) \
  (GetCurrentModule())->FPtrs[HE_RCRenameFileHFS]) \
  (fs, szOldName, szNewName)
#define RCAbandonHF(f) \
  ((LPFN_RCABANDONHF)(GetCurrentModule())->FPtrs[HE_RCAbandonHF]) \
  (f)
#define HFSCreateFileSys(szName, Something) \
  ((LPFN_HFSCREATEFILESYS) \
  (GetCurrentModule())->FPtrs[HE_HFSCreateFileSys]) \
  (szName, Something)
#define RCDestroyFileSys(szName) ((LPFN_RCDESTROYFILESYS) \
  (GetCurrentModule())->FPtrs[HE_RCDestroyFileSys]) \
  (szName)

// LGetInfo crackers
#define LGetHInstance() (HINSTANCE)LGetInfo (GI_HINSTANCE, 0)
#define LGetMainHWnd() (HWND)LGetInfo (GI_MAINHWND, 0)
#define LGetCurrHWnd() (HWND)LGetInfo (GI_CURRHWND, 0)
#define LGetHFS(wnd) (HFS)LGetInfo (GI_HFS, wnd)
#define LGetFGColor(wnd) LGetInfo (GI_FGCOLOR, wnd)
#define LGetBKColor(wnd) LGetInfo (GI_BKCOLOR, wnd)
#define LGetTopicNo(wnd) LGetInfo (GI_TOPICNO, wnd)
char far * LGetHPath (HWND wnd); // in HELPDLL.C

