//***************************************************************************
//
//  MASKBMP.CPP
//
//***************************************************************************

#include "maskbmp.h"

void CMaskedBitmap::Draw (CDC* pDC, int x, int y)
{
    // Convert the bitmap's origin and dimensions to logical units
    BITMAP bm;
    GetObject (sizeof (bm), &bm);
    CPoint size (bm.bmWidth, bm.bmHeight);
    pDC->DPtoLP (&size);

    CPoint org (0, 0);
    pDC->DPtoLP (&org);

    // Create a memory DC and select the bitmap into it
    CDC mdc;
    mdc.CreateCompatibleDC (pDC);
    CBitmap* pDefaultBitmap = mdc.SelectObject (this);
    mdc.SetMapMode (pDC->GetMapMode ());

    // BitBlt the image from the memory DC to the screen DC
    pDC->BitBlt (x, y, size.x, size.y, &mdc, org.x, org.y, SRCCOPY);

    // Reselect the memory DC's default bitmap
    mdc.SelectObject (pDefaultBitmap);
}

void CMaskedBitmap::DrawTransparent (CDC* pDC, int x, int y, COLORREF crColor)
{
    // Convert the bitmap's origin and dimensions to logical units
    BITMAP bm;
    GetObject (sizeof (bm), &bm);
    CPoint size (bm.bmWidth, bm.bmHeight);
    pDC->DPtoLP (&size);

    CPoint org (0, 0);
    pDC->DPtoLP (&org);

    // Create a memory DC (mdcImage) and select the bitmap into it
    CDC mdcImage;
    mdcImage.CreateCompatibleDC (pDC);
    CBitmap* pOldBitmapImage = mdcImage.SelectObject (this);
    mdcImage.SetMapMode (pDC->GetMapMode ());

    // Create another memory DC (mdcOr) and copy the bitmap image to it
    CDC mdcOr;
    mdcOr.CreateCompatibleDC (pDC);
    mdcOr.SetMapMode (pDC->GetMapMode ());

    CBitmap bitmapOr;
    bitmapOr.CreateCompatibleBitmap (&mdcImage, bm.bmWidth, bm.bmHeight);
    CBitmap* pOldBitmapOr = mdcOr.SelectObject (&bitmapOr);

    mdcOr.BitBlt (org.x, org.y, size.x, size.y, &mdcImage, org.x, org.y,
        SRCCOPY);

    // Create an AND mask from the bitmap image
    CDC mdcAnd;
    mdcAnd.CreateCompatibleDC (pDC);
    mdcAnd.SetMapMode (pDC->GetMapMode ());

    CBitmap bitmapAnd;
    bitmapAnd.CreateBitmap (bm.bmWidth, bm.bmHeight, 1, 1, NULL);
    CBitmap* pOldBitmapAnd = mdcAnd.SelectObject (&bitmapAnd);

    COLORREF crOldBkColor = mdcImage.SetBkColor (crColor);
    mdcAnd.BitBlt (org.x, org.y, size.x, size.y, &mdcImage, org.x, org.y,
        SRCCOPY);
    mdcImage.SetBkColor (crOldBkColor);

    // Create an inverse AND mask from the AND mask
    CDC mdcInvAnd;
    mdcInvAnd.CreateCompatibleDC (pDC);
    mdcInvAnd.SetMapMode (pDC->GetMapMode ());

    CBitmap bitmapInvAnd;
    bitmapInvAnd.CreateBitmap (bm.bmWidth, bm.bmHeight, 1, 1, NULL);
    CBitmap* pOldBitmapInvAnd = mdcInvAnd.SelectObject (&bitmapInvAnd);

    mdcInvAnd.BitBlt (org.x, org.y, size.x, size.y, &mdcAnd, org.x, org.y,
        NOTSRCCOPY);

    // Apply the inverse AND mask to the image in mdcOr to create an OR mask
    mdcOr.BitBlt (org.x, org.y, size.x, size.y, &mdcInvAnd, org.x, org.y,
        SRCAND);

    // Copy the destination rectangle from the screen DC to a memory DC
    CDC mdcDest;
    mdcDest.CreateCompatibleDC (pDC);
    mdcDest.SetMapMode (pDC->GetMapMode ());

    CBitmap bitmapDest;
    bitmapDest.CreateCompatibleBitmap (&mdcImage, bm.bmWidth, bm.bmHeight);
    CBitmap* pOldBitmapDest = mdcDest.SelectObject (&bitmapDest);

    mdcDest.BitBlt (org.x, org.y, size.x, size.y, pDC, x, y, SRCCOPY);

    // Apply the AND mask to the destination memory DC
    mdcDest.BitBlt (org.x, org.y, size.x, size.y, &mdcAnd, org.x, org.y,
        SRCAND);

    // Apply the OR mask to the destination memory DC
    mdcDest.BitBlt (org.x, org.y, size.x, size.y, &mdcOr, org.x, org.y,
        SRCINVERT);

    // Copy the resulting image to the screen
    pDC->BitBlt (x, y, size.x, size.y, &mdcDest, org.x, org.y, SRCCOPY);

    // Restore default bitmaps
    mdcDest.SelectObject (pOldBitmapDest);
    mdcInvAnd.SelectObject (pOldBitmapInvAnd);
    mdcAnd.SelectObject (pOldBitmapAnd);
    mdcOr.SelectObject (pOldBitmapOr);
    mdcImage.SelectObject (pOldBitmapImage);
}
