// cntrview.cpp : implementation of the CCntrView class
//

#include "stdafx.h"
#include "cntr.h"

#include "cntrdoc.h"
#include "cntritem.h"
#include "cntrview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCntrView

IMPLEMENT_DYNCREATE(CCntrView, CView)

BEGIN_MESSAGE_MAP(CCntrView, CView)
	//{{AFX_MSG_MAP(CCntrView)
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	ON_COMMAND(ID_OLE_INSERT_NEW, OnInsertObject)
	ON_COMMAND(ID_CANCEL_EDIT_CNTR, OnCancelEditCntr)
	ON_WM_LBUTTONDOWN()
	ON_WM_SETCURSOR()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR, OnUpdateEditClear)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCntrView construction/destruction

CCntrView::CCntrView()
{
	m_pSelection = NULL;
	// TODO: add construction code here

}

CCntrView::~CCntrView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CCntrView drawing

void CCntrView::OnDraw(CDC* pDC)
{

	// TODO: add draw code for native data here
	// TODO: also draw all OLE items in the document

	// Draw the selection at an arbitrary position.  This code should be
	//  removed once your real drawing code is implemented.  This position
	//  corresponds exactly to the rectangle returned by CCntrItem,
	//  to give the effect of in-place editing.


	CCntrDoc* pDoc = GetDocument();
 	ASSERT_VALID(pDoc);

    POSITION pos = pDoc->GetStartPosition();
    while (pos != NULL)
        {
        // draw the item
        CCntrItem* pItem = 
        (CCntrItem*)pDoc->GetNextItem(pos);
        pItem->Draw(pDC, pItem->m_rect);
	
    // draw the tracking rectangle over the item
        CRectTracker tracker;
        InitTracker(pItem, &tracker);
        tracker.Draw(pDC);
        }
}

void CCntrView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	// TODO: remove this code when final selection model code is written
	m_pSelection = NULL;    // initialize selection

}

/////////////////////////////////////////////////////////////////////////////
// CCntrView printing

BOOL CCntrView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCntrView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCntrView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// OLE Client support and commands

BOOL CCntrView::IsSelected(const CObject* pDocItem) const
{
	// The implementation below is adequate if your selection consists of
	//  only CCntrItem objects.  To handle different selection
	//  mechanisms, the implementation here should be replaced.

	// TODO: implement this function that tests for a selected OLE client item

	return pDocItem == m_pSelection;
}

void CCntrView::OnInsertObject()
{
	// Invoke the standard Insert Object dialog box to obtain information
	//  for new CCntrItem object.
	COleInsertDialog dlg;
	if (dlg.DoModal() != IDOK)
		return;

	BeginWaitCursor();

	CCntrItem* pItem = NULL;
	TRY
	{
		// Create new item connected to this document.
		CCntrDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new CCntrItem(pDoc);
		ASSERT_VALID(pItem);

		// Initialize the item from the dialog data.
		if (!dlg.CreateItem(pItem))
			AfxThrowMemoryException();  // any exception will do
		ASSERT_VALID(pItem);

#if !defined(OLD)
	  	pItem->UpdateLink(); 
		pItem->UpdateExtent();
#endif

		// If item created from class list (not from file) then launch
		//  the server to edit the item.
		if (dlg.GetSelectionType() == COleInsertDialog::createNewItem)
			pItem->DoVerb(OLEIVERB_SHOW, this);

		ASSERT_VALID(pItem);

		// As an arbitrary user interface design, this sets the selection
		//  to the last item inserted.

#ifdef OLD
		// TODO: reimplement selection as appropriate for your application
		m_pSelection = pItem;   // set selection to last inserted item
		pDoc->UpdateAllViews(NULL);
#else
		SelectItem(pItem);
		pItem->InvalidateItem;
#endif
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH

	EndWaitCursor();
}

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the container (not the server) causes the deactivation.
void CCntrView::OnCancelEditCntr()
{
	// Close any in-place active item on this view.
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
	{
		pActiveItem->Close();
	}
	ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
}

// Special handling of OnSetFocus and OnSize are required for a container
//  when an object is being edited in-place.
void CCntrView::OnSetFocus(CWnd* pOldWnd)
{
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL &&
		pActiveItem->GetItemState() == COleClientItem::activeUIState)
	{
		// need to set focus to this item if it is in the same view
		CWnd* pWnd = pActiveItem->GetInPlaceWindow();
		if (pWnd != NULL)
		{
			pWnd->SetFocus();   // don't call the base class
			return;
		}
	}

	CView::OnSetFocus(pOldWnd);
}

void CCntrView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
		pActiveItem->SetItemRects();
}

/////////////////////////////////////////////////////////////////////////////
// CCntrView diagnostics

#ifdef _DEBUG
void CCntrView::AssertValid() const
{
	CView::AssertValid();
}

void CCntrView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCntrDoc* CCntrView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCntrDoc)));
	return (CCntrDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCntrView message handlers

void CCntrView::OnLButtonDown(UINT nFlags, CPoint point) 
{
		// We have to add: CheckHitTest...
    CCntrItem* pItem = CheckHitTest(point);	
    SelectItem(pItem);	// ...and SelectItem...
    if(pItem)
        {		// ... and SetupTracker
        CRectTracker rectTracker;
        InitTracker(pItem,&rectTracker);
        if(rectTracker.Track(this, point))
            {
#ifdef OLD
            Invalidate();
            pItem->m_rect = rectTracker.m_rect;
#else
			pItem->InvalidateItem();
			pItem->m_rect = rectTracker.m_rect;
			pItem->InvalidateItem();
#endif
            GetDocument()->SetModifiedFlag();
            }
        }
    CView::OnLButtonDown(nFlags, point);
}

	// swing thru list of items in the COleDocument
	// via COleDocument::GetStartPosition and
	// COleDocument::GetNextItem, and return a 
	// pointer to the item if it was clicked
CCntrItem* CCntrView::CheckHitTest(CPoint point)
{
    CCntrDoc* pDoc = GetDocument();
    CCntrItem* pItemHit = NULL;
    POSITION pos = pDoc->GetStartPosition();
    while(pos != NULL)
        {
        CCntrItem* pItem = 
        (CCntrItem*)pDoc->GetNextItem(pos);
        if (pItem->m_rect.PtInRect(point))
            pItemHit = pItem;
        }
    return pItemHit;	// return top item at point
}  

void CCntrView::SelectItem(CCntrItem* pItem)
{   
		// if no item hit, and no item previously selected
	if((pItem == NULL) && (m_pSelection == NULL))
		return;
        // if another item was already selected,
        // close in-place active item
    if(m_pSelection != pItem)
    	{	
        // retrieve pointer to current item and close it
        COleClientItem* pActive 
            = GetDocument()->GetInPlaceActiveItem(this);
        if((pActive != NULL) && (pActive != pItem))
			pActive->Close();
		if((pActive != pItem) && (pItem != NULL))
			{
			GetDocument()->RemoveItem(pItem);
			GetDocument()->AddItem(pItem);
			GetDocument()->SetModifiedFlag();
			}
#ifdef OLD
		Invalidate();
    	m_pSelection = pItem;	// select our item
#else
// update view to new selection
		if(m_pSelection != pItem)
			{
			if(m_pSelection != NULL)
				OnUpdate(NULL, HINT_UPDATE_ITEM, m_pSelection);
			m_pSelection = pItem;
			if(m_pSelection != NULL)
				OnUpdate(NULL, HINT_UPDATE_ITEM, m_pSelection);
        	}
#endif
		}
}    

void CCntrView::InitTracker(CCntrItem* pItem,
	CRectTracker* pTrac)
{
    pTrac->m_rect = pItem->m_rect;

    if(pItem == m_pSelection)
        pTrac->m_nStyle |= CRectTracker::resizeInside;
    if(pItem->GetType() == OT_LINK)
        pTrac->m_nStyle |= CRectTracker::dottedLine;
    else 
        pTrac->m_nStyle |= CRectTracker::solidLine;
    if((pItem->GetItemState() == COleClientItem::openState) ||
       (pItem->GetItemState() == COleClientItem::activeUIState))
        {	
        pTrac->m_nStyle |= CRectTracker::hatchInside;
        }
}


BOOL CCntrView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if(pWnd == this && m_pSelection != NULL)
        {
    // give the tracker for the selection a chance
        CRectTracker tracker;
        InitTracker(m_pSelection, &tracker);
            // returns TRUE if hit over tracker
        if(tracker.SetCursor(this, nHitTest))
            return TRUE;
        }
	return CView::OnSetCursor(pWnd, nHitTest, message);
}

void CCntrView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	if (m_pSelection != NULL)
		{
		m_pSelection->DoVerb(
			(::GetKeyState(VK_CONTROL) < 0 ? 
				OLEIVERB_OPEN : OLEIVERB_PRIMARY),
			this);
		}
	CView::OnLButtonDblClk(nFlags, point);
	
}

void CCntrView::OnEditClear() 
{
	if (m_pSelection != NULL) // not really needed
        {
        m_pSelection->Delete();
        m_pSelection = NULL;
        GetDocument()->UpdateAllViews(NULL);
		GetDocument()->SetModifiedFlag();
        }
	
}

void CCntrView::OnUpdateEditClear(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pSelection != NULL);		
}

void CCntrView::DrawItem(CCntrItem *pItem, CDC* pDC)
{
	pItem->Draw(pDC, pItem->m_rect);
	
    // draw the tracking rectangle over the item
    CRectTracker tracker;
    InitTracker(pItem, &tracker);
    tracker.Draw(pDC);
}

void CCntrView::OnEditCopy() 
{
	if(m_pSelection)
		m_pSelection->CopyToClipboard();	
}

void CCntrView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pSelection != NULL);	
}

void CCntrView::OnEditPaste() 
{
	CCntrItem* pItem = NULL;
		
	TRY
	{
		// Create new item connected to this document.
		CCntrDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new CCntrItem(pDoc);
		ASSERT_VALID(pItem);
		
		// Initialize the item from clipboard data
		if (!pItem->CreateFromClipboard())
			AfxThrowMemoryException();	// any exception will do
		ASSERT_VALID(pItem);
		
		// update the size before displaying
		pItem->UpdateExtent();

// set selection to newly pasted item
		SelectItem(pItem);	
		pItem->InvalidateItem();	
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}	
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH	
}

void CCntrView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	switch (lHint)
		{
		case HINT_UPDATE_WINDOW:	// invalidate entire window
			Invalidate();
			break;
		case HINT_UPDATE_ITEM:		// invalidate single item
			{
				CRectTracker tracker;
				InitTracker((CCntrItem*)pHint, &tracker);
				CRect rect;
				tracker.GetTrueRect(rect);
				InvalidateRect(rect);
			}
			break;
		}	
}
