//***************************************************************************
//
//  SBDemo1.c
//
//***************************************************************************

#include <windows.h>
#include <commctrl.h>
#include "SBDemo1.h"

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szWndClass[] = "SBDemo1";
    WNDCLASS wc;
    HWND hwnd;
    MSG msg;

    wc.style = 0;
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = "MainMenu";
    wc.lpszClassName = szWndClass;

    RegisterClass (&wc);

    hwnd = CreateWindow (szWndClass, "Status Bar Demo 1",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, HWND_DESKTOP, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam,
                          LPARAM lParam)
{
    HMENU hMenu;
    static HINSTANCE hInstance;
    static HWND hwndStatusBar;
    UINT uItem, fuFlags;
    char szHelpText[64];
    
    switch (message) {
    
    case WM_CREATE:
        //
        // Create the status bar.
        //
        InitCommonControls ();
        hwndStatusBar = CreateStatusWindow (WS_CHILD | WS_VISIBLE,
            "Ready", hwnd, IDC_STATUS_BAR);

        hInstance = ((LPCREATESTRUCT) lParam)->hInstance;
        return 0;

    case WM_SIZE:
        //
        // Echo WM_SIZE messages to the status bar.
        //
        SendMessage (hwndStatusBar, WM_SIZE, wParam, lParam);
        return 0;
    
    case WM_MENUSELECT:
        //
        // Update the status bar as the user browses the menus.
        //
        uItem = LOWORD (wParam);
        fuFlags = HIWORD (wParam);

        if ((fuFlags == 0xFFFF) && (lParam == 0))
            SendMessage (hwndStatusBar, SB_SETTEXT, 0, (LPARAM) "Ready");

        else if ((uItem >= IDM_FILE_NEW) && (uItem <= IDM_HELP_ABOUT)) {
            LoadString (hInstance, uItem, szHelpText, sizeof (szHelpText));
            SendMessage (hwndStatusBar, SB_SETTEXT, 0, (LPARAM) szHelpText);
        }

        else
            SendMessage (hwndStatusBar, SB_SETTEXT, 0, (LPARAM) "");

        return 0;

    case WM_COMMAND:
        //
        // Process menu selections.
        //
        switch (LOWORD (wParam)) {

        case IDM_VIEW_STATUS_BAR:
            //
            // Display or hide the status bar.
            //
            hMenu = GetMenu (hwnd);

            if (IsWindowVisible (hwndStatusBar)) {
                ShowWindow (hwndStatusBar, SW_HIDE);
                CheckMenuItem (hMenu, IDM_VIEW_STATUS_BAR, MF_UNCHECKED);
            }
            else { // Not visible
                ShowWindow (hwndStatusBar, SW_SHOW);
                CheckMenuItem (hMenu, IDM_VIEW_STATUS_BAR, MF_CHECKED);
            }           
            return 0;
        }
        break;
    
    case WM_DESTROY:
        //
        // Terminate the application.
        //
        PostQuitMessage (0);
        return 0;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}
