//***********************************************************************
//
//  Circle.cpp
//
//***********************************************************************

#include <afxwin.h>
#include "Circle.h"

IMPLEMENT_SERIAL (CCircle, CObject, 1)

CCircle::CCircle (LPRECT pRect)
{
    m_rect.left = pRect->left;
    m_rect.top = pRect->top;
    m_rect.right = pRect->right;
    m_rect.bottom = pRect->bottom;
}

void CCircle::Serialize (CArchive& ar)
{
    if (ar.IsStoring ())
        ar << m_rect;
    else
        ar >> m_rect;
}

void CCircle::Draw (CDC* pDC)
{
    CPen pen (PS_SOLID, 10, RGB (255, 0, 0));
    CPen* pOldPen = pDC->SelectObject (&pen);
    pDC->SelectStockObject (NULL_BRUSH);
    pDC->Ellipse (m_rect);
    pDC->SelectObject (pOldPen);
}
