*********************************************************************
* FUNCTION Xwrap                              FoxPro for MS-DOS 2.6
* Prints a character string using the STYLE clause. Expects _WRAP to
* be .T., and uses _LMARGIN and _RMARGIN to anticipate a word wrap so
* the word doesn't wrap and doesn't lose the current STYLE clause.
*
* Parameter 1 - The string to be printed
* Parameter 2 - A string that defines the STYLE clause. An empty
*               string will default to Normal
* Parameter 3 - .T. to output the string on a newline (?), or .F.
*               to continue on the same line (??). Defaults to .T.
*********************************************************************
FUNCTION xwrap
PARAMETER instring, outstyle, newline
PRIVATE nextspace, outstring, fromcol
IF TYPE('outstyle') = 'L' ;
   OR EMPTY(outstyle)
   outstyle = "N"
ENDIF
IF PARAMETERS() < 3
   newline = .T.        && Default to newline if not explicitly .F.
ENDIF
outstring = ""
IF newline
   ?
ENDIF

* In case some text is already on this line
fromcol = IIF(_pcolno > _lmargin, _pcolno, _lmargin)

DO WHILE LEN(instring) > 0
   nextspace = IIF(AT(" ",instring)>0,AT(" ",instring),LEN(instring))
   *
   * If the next word would wrap
   *
   IF fromcol + LEN(outstring) + nextspace > _rmargin
      ?? outstring style (outstyle) AT (fromcol)
      outstring = ""
      ?                       && Wrap
      fromcol = _lmargin      && Reset
   ENDIF
   outstring = outstring + LEFT(instring, nextspace)
   instring = RIGHT(instring, LEN(instring) - nextspace)
ENDDO
?? outstring style (outstyle) AT (fromcol)
RETURN
