// SpaceFrame.h : header file
//

#include "GameFrame.h"

/////////////////////////////////////////////////////////////////////////////
// CSpaceFrame frame

class CAnim;

enum SpriteType
{
  typeShip,
  typeEnemy,
  typeBullet
};

typedef struct _SPRITE
{
    struct  _SPRITE* pNext;         
    struct  _SPRITE* pPrev;         
    SpriteType       eType;         
    double           dPosX, dPosY;  
    double           dVelX, dVelY;  
    int              nDirection;
    int              nFrame;  
    int              nDelay;
    CAnim*           pAnim;
} SPRITE;

const int NUM_DIRECTIONS = 32;
const int WORLD_MIN_X = 0;
const int WORLD_MIN_Y = 0;
const int WORLD_MAX_X = 640;
const int WORLD_MAX_Y = 480;
const int ANIM_DELAY = 5;
const int TURN_DELAY = 0;

class CSpaceFrame : public CGameFrame
{
public:
	CSpaceFrame();           // protected constructor used by dynamic creation
	virtual ~CSpaceFrame();

// Operations
public:
	virtual BOOL InitGraphics();
  virtual void KillGraphics();

	virtual BOOL UpdateGame();

protected:
  void MoveSprites();
  void CollideSprites();
  void DrawSprites();

  SPRITE* AddSprite(SpriteType eType,
                    double dX = 0.0,
                    double dY = 0.0);

  void RemoveSprite(SPRITE* pSprite);

  BOOL InitLevel(int nDifficulty = 0);
  void KillLevel();

  void DisplayMessage(char* pStr);
  void DisplayLevel();

	virtual BOOL InitPalette();
  virtual BOOL RestoreSurfaces();

  void DrawText();

  int RandVal( int low, int high );
  double RandVal( double low, double high );

// Attributes
protected:
  // ddraw vars
  LPDIRECTDRAWSURFACE m_pFrameRateSurface;
  LPDIRECTDRAWSURFACE m_pTextSurface;
  DDBLTFX m_ddbltfx;
  DDSURFACEDESC m_ddsd;

  // anims
  CAnim* m_pShipAnim;
  CAnim* m_pBulletAnim;
  CAnim* m_pEnemyAnim;

  // head node of sprite list
  SPRITE m_head;

  // Variables used in frame rate calculations
	CFont m_font;
	DWORD m_dwStartTime;
	int m_nFrameCount;
  int m_nFrameRate;

  int m_nLives;
  int m_nLevel;
  int m_nTurnDelay;

// Overrides
protected:
  CString GetWindowTitle();

public:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSpaceFrame)
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaceFrame)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
