'*********************************************************************
' Function BdayAdd(datStart, intDays)                Microsoft Access
'
' Add intDays days to datStart, making sure the resulting date is a
' working business day, excluding weekends and holidays listed in the
' holidays table.
'*********************************************************************
Public Function BdayAdd(datStart As Date, intDays As Integer) As Date
Dim datEnd As Date
'
' Start by adding the number of days to the startdate
'
datEnd = DateAdd("d", datStart, intDays)
'
' Eliminate weekends and holidays
'
While IsWeekend(datEnd) Or IsHoliday(datEnd)
   datEnd = DateAdd("d", datEnd, 1)   ' Move forward one
Wend
BdayAdd = datEnd  ' Assign result for return value

End Function

'*********************************************************************
' Function IsWeekend(AnyDate As Date)                Microsoft Access
' Returns True if Date is a Saturday or Sunday
'*********************************************************************
Public Function IsWeekend(AnyDate As Date)
If (DatePart("w", AnyDate) = 1) Or (DatePart("w", AnyDate) = 7) Then
   IsWeekend = True
Else
   IsWeekend = False
End If
End Function

'*********************************************************************
' Function IsHoliday(AnyDate As Date)                Microsoft Access
' Returns True if AnyDate is a Holiday, False Otherwise.
' Uses the Holidays table to check for holidays.
'*********************************************************************
Public Function IsHoliday(AnyDate As Date)
If (DCount("[Date]", "Holidays", "[Date]=#" & Format(AnyDate, "mm/d/yyyy") & "#") > 0) Then
   IsHoliday = True
Else
   IsHoliday = False
End If
End Function

