
//
// npshell.cpp - Plug-in methods called from Netscape.
//

#include <windows.h>
#include "npapi.h"
#include "npmciwnd.h"

//
// NPP_Initialize
//
NPError NPP_Initialize(void)
{
    return NPERR_NO_ERROR;
}


//
// NPP_Shutdown
//
void NPP_Shutdown(void)
{
}


//
//	NPP_GetJavaClass - This plug-in does not use the Java Runtime Interface (JRI)
//
jref NPP_GetJavaClass (void)
{
	// If no java is used return NULL.

	return NULL;
}


//
// NPP_New - Create a new plug-in instance.
//
NPError NP_LOADDS NPP_New (NPMIMEType pluginType,
	NPP pInstance,
    uint16 mode,
    int16 argc,
    char* argn[],
    char* argv[],
    NPSavedData* saved)
{   
    if (pInstance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

	// Create a new CMCIWnd object

	CMCIWnd* pMCIWnd = new CMCIWnd ();

	// Attach it to the instance structure

	pInstance->pdata = pMCIWnd;

    return NPERR_NO_ERROR;
}


//
// NPP_Destroy - Destroy our plug-in instance.
//
NPError NP_LOADDS NPP_Destroy (NPP pInstance, NPSavedData** save)
{
    CMCIWnd* pMCIWnd = (CMCIWnd *)pInstance->pdata;

	if (pMCIWnd)
	{
		delete pMCIWnd;
		pInstance->pdata = NULL;
	}
	return NPERR_NO_ERROR;
}
	

//
// NPP_SetWindow - Just get the window handle.
//
NPError NP_LOADDS NPP_SetWindow (NPP pInstance, NPWindow* window)
{
	if (!window)
        return NPERR_GENERIC_ERROR;

    if (!pInstance)
        return NPERR_INVALID_INSTANCE_ERROR;

    CMCIWnd* pMCIWnd = (CMCIWnd *)pInstance->pdata; 

    if (!pMCIWnd) 
        return NPERR_GENERIC_ERROR;

	// Spurious entry - just return

    if (!window->window && !pMCIWnd->hNavigatorWnd) 
        return NPERR_NO_ERROR;

	// Get Navigator's window handle

	if (window->window)
	{
		if (!pMCIWnd->hNavigatorWnd)
			pMCIWnd->hNavigatorWnd = (HWND)window->window;
		else
		{
			pMCIWnd->UpdateWindow (pMCIWnd->hNavigatorWnd);
		}
	}
	
	return NPERR_NO_ERROR;

}


//
// NPP_NewStream - A new stream was created.
//
NPError NP_LOADDS NPP_NewStream(NPP pInstance,
	NPMIMEType type,
	NPStream* pStream, 
	NPBool seekable,
	uint16* stype)
{
    if(!pInstance)
        return NPERR_INVALID_INSTANCE_ERROR;

	*stype = NP_ASFILEONLY;

    return NPERR_NO_ERROR;
}


//
// NPP_WriteReady - Returns amount of data we can handle for the next NPP_Write
//                             
int32 NP_LOADDS	NPP_WriteReady (NPP pInstance, NPStream *stream)
{
	return 0x0FFFFFFF;
}


//
// NPP_Write 
// 
int32 NP_LOADDS NPP_Write (NPP pInstance, NPStream *stream, int32 offset, int32 len, void *buffer)
{   
    return len;
}


//
// NPP_StreamAsFile 
// 
void NP_LOADDS NPP_StreamAsFile (NPP pInstance, 
	NPStream* stream, 
	const char* fname)
{
	CMCIWnd* pMCIWnd = (CMCIWnd *)pInstance->pdata;
 	
 	if (pMCIWnd)   
    	pMCIWnd->GotFileName (fname);
}
 

//
// NPP_DestroyStream 
// 
NPError NP_LOADDS NPP_DestroyStream (NPP pInstance, NPStream *stream, NPError reason)
{
    return NPERR_NO_ERROR;
}


//
// NPP_Print - This plug-in does not print.
//
void NP_LOADDS NPP_Print (NPP pInstance, NPPrint* printInfo)
{
}
	




