// TicDoc.cpp : implementation of the CTicDoc class
//

#include "stdafx.h"
#include "Tic.h"

#include "TicDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTicDoc

IMPLEMENT_DYNCREATE(CTicDoc, CDocument)

BEGIN_MESSAGE_MAP(CTicDoc, CDocument)
	//{{AFX_MSG_MAP(CTicDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTicDoc construction/destruction

CTicDoc::CTicDoc()
{
	// TODO: add one-time construction code here

}

CTicDoc::~CTicDoc()
{
}

BOOL CTicDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	for (int i=0; i<5; i++)
		for (int j=0; j<5; j++)
			m_grid[i][j] = 0;

	m_bXsTurn = TRUE;
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CTicDoc serialization

void CTicDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		for (int i=0; i<5; i++)
			for (int j=0; j<5; j++)
				ar << m_grid[i][j];
		ar << m_bXsTurn;
	}
	else
	{
		for (int i=0; i<5; i++)
			for (int j=0; j<5; j++)
				ar >> m_grid[i][j];
		ar >> m_bXsTurn;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTicDoc diagnostics

#ifdef _DEBUG
void CTicDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTicDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTicDoc commands

void CTicDoc::AddX (int i, int j)
{
	if ((i >= 0) && (i <= 4) && (j >= 0) && (j <= 4)) {
		m_grid[i][j] = 1;	// Add an X to the grid
		SetModifiedFlag ();	// Set the documents modified flag
		m_bXsTurn = FALSE;	// O comes next
	}
}

void CTicDoc::AddO (int i, int j)
{
	if ((i >= 0) && (i <= 4) && (j >= 0) && (j <= 4)) {
		m_grid[i][j] = 2;	// Add an O to the grid
		SetModifiedFlag ();	// Set the documents modified flag
		m_bXsTurn = TRUE;	// X comes next
	}
}

BYTE CTicDoc::GetSquare (int i, int j)
{
    if ((i >= 0) && (i <= 4) &&
        (j >= 0) && (j <= 4))
        return m_grid[i][j];

    return (BYTE) -1;
}

BOOL CTicDoc::IsItXsTurn ()
{
	return m_bXsTurn;
}
