//===================================================================
// HelloCE  - A simple application for Windows CE
// Copyright (C) 1997 Ziff Davis Communications
//===================================================================

#include <windows.h>         // For all that Win stuff
#include <commctrl.h>        // For command bar 

#define    IDC_CMDBAR    1   // ID value for command bar
#define    IDI_ICON1     101 // ID value for command bar

// Window procedures
LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

//-----------------------------------------------------------
// Global data
//-----------------------------------------------------------
const TCHAR szAppName[] = TEXT("HelloCE");
HINSTANCE hInst;                     // Program instance handle

//============================================================
// Program Entry Point
//============================================================
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPWSTR lpCmdLine, int nCmdShow) {
	WNDCLASS  wc;
	HWND      hWnd;
	MSG       msg;

	// Save prog instance handle in global var
	hInst = hInstance;

	// Register App Main Window class
	wc.style = 0;                             // Window style
	wc.lpfnWndProc = MainWndProc;             // Callback function
	wc.cbClsExtra = 0;                        // Extra class data
	wc.cbWndExtra = 0;                        // Extra window data
	wc.hInstance = hInstance;                 // Owner handle
	wc.hIcon = NULL;                          // Application icon
	wc.hCursor = NULL;                        // Default cursor
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName =  NULL;                  // Menu name
	wc.lpszClassName = szAppName;             // Window class name

	if (RegisterClass(&wc) == 0)
		return 1;

	// Create main window
	hWnd = CreateWindow (szAppName,           // Window Class
	                     TEXT("Hello"),       // Window Title
						 WS_VISIBLE,          // Style flags
						 0, 0,                // x, y position
						 CW_USEDEFAULT,       // Initial Width
						 CW_USEDEFAULT,       // Initial Height
						 NULL,                // Parent                
						 NULL,                // Menu, must be null
						 hInstance,           // App instance
						 NULL);               // Ptr to create params
	// Return fail code if window not created
	if ((!hWnd) || (!IsWindow (hWnd)))
		return 0x10;
	
	// Standard show and update calls
	ShowWindow (hWnd, nCmdShow);
	UpdateWindow (hWnd);
	
	// Application message loop
	while (GetMessage (&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}
//============================================================
// Message handling procedures for MainWindow
//============================================================
//------------------------------------------------------------
// MainWndProc - Callback function for application window
//------------------------------------------------------------
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT wMsg, WPARAM wParam, 
                             LPARAM lParam) {
	HWND hwndCB;
	PAINTSTRUCT ps;
	HICON hIcon;
	RECT rect;
	HDC hdc;

	switch (wMsg) {
	case WM_CREATE:
		// Create a command bar
		hwndCB = CommandBar_Create (hInst, hWnd, IDC_CMDBAR);
		// Add exit button to command bar. 
		CommandBar_AddAdornments (hwndCB, 0, 0);

		// Since icons are registered  on a class basis, see if one already exists
		// for this class.
		hIcon = (HICON) SendMessage (hWnd, WM_GETICON, FALSE, 0);
		if (hIcon == NULL) {
			hIcon = LoadImage (hInst, MAKEINTRESOURCE (IDI_ICON1), IMAGE_ICON, 16,16,0);
			SendMessage (hWnd, WM_SETICON, FALSE, (LPARAM) hIcon);
		}
		return 0;

	case WM_PAINT:
		// Adjust the size of the client rect to take into account
		// the command bar height.
		GetClientRect (hWnd, &rect);
		rect.top += CommandBar_Height (GetDlgItem (hWnd, IDC_CMDBAR));

		hdc = BeginPaint (hWnd, &ps); 
		DrawText (hdc, TEXT ("Hello Windows CE!"), -1, &rect, 
		          DT_CENTER | DT_VCENTER | DT_SINGLELINE);

		EndPaint (hWnd, &ps); 
		return 0;

	case WM_HIBERNATE:
		// If not the active window, nuke the cmd bar to save memory
		if (GetActiveWindow() != hWnd)
			CommandBar_Destroy (GetDlgItem (hWnd, IDC_CMDBAR));

		break;

	case WM_ACTIVATE:
		// If activating and no command bar, create it.
		if ((LOWORD (wParam) != WA_INACTIVE) &&
			(GetDlgItem (hWnd, IDC_CMDBAR) == 0)) {

			// Create a command bar
			hwndCB = CommandBar_Create (hInst, hWnd, IDC_CMDBAR);
			CommandBar_AddAdornments (hwndCB, 0, 0);
		}
		break;
	}
	return DefWindowProc(hWnd, wMsg, wParam, lParam);
}
