;-----------------------------------------------------------------------------
;DSTRIP - Dos Filter to remove leading and trailing blanks, blank lines and
;         comment lines, from Dbase command files, and to capitalize text
;         not in quotation marks.
;-----------------------------------------------------------------------------
COMSEG	SEGMENT	PARA PUBLIC 'CODE'
	ASSUME	CS:COMSEG,DS:COMSEG,ES:COMSEG,SS:COMSEG
	ORG 	100H

START	PROC	FAR
	CLD
	MOV	BL,00000001B	;the bits in the BL register will hold the 
				;following information when set to 1:
				;0-bit  only tabs and blanks encountered
				;       in current line
			        ;1-bit a '*' encountered as first char of line
				;4-bit	char inside 'single' quotes
				;5-bit	char inside "double" quotes
				;6-bit	last char was LF
				;7-bit  last char in *-line was a ';'
	XOR	DX,DX		;DX will count blanks/tabs after a char
LOAD:	PUSH 	BX		;save registers and 
	PUSH	DX
	MOV	DX,OFFSET DATA	;read into memory
	MOV	CX,64000	;64K bytes
	XOR	BX,BX		;from standard input
	MOV 	AH,3FH		;with DOS function call
	INT	21H
	POP	DX		;restore registers
	POP	BX
	OR	AX,AX		;AX has number of bytes read - test for 0
	JNZ	LOAD0
	JMP	DONE
LOAD0:	MOV	CX,AX		;move count into CX
	MOV	SI,OFFSET DATA	;and position index registers for
	MOV	DI,OFFSET DATA	;a string move
SCAN0:	LODSB			;fetch a byte into AL
	CMP	AL,26		;end of file?
	JZ	STORE		;if so, store and get out
	TEST	BL,01000000B	;LF on previous fetch?
	JZ	NEXT		;if not, skip
	OR	BL,1		;set beginning of line bit
	AND	BL,10111111B	;and reset the LF bit
	TEST	BL,10000000B	;a ';' at end of line?
	JNZ	NEXT0		;if yes, skip
	AND	BL,11111101B	;otherwise reset '*'-bit
NEXT0:	AND	BL,01111111B	;reset ';'-bit
NEXT:	CMP	AL,59		;a ';'?
	JNZ	NEXT1		;if not, skip
	OR	BL,10000000B	;set ';'-bit
	JMP	SHORT NEXT5	;and do loop routine
NEXT1:	CMP	AL,32		;blank?
	JZ	COUNT		;if yes, check whether to count it
	CMP	AL,09		;tab?
	JNZ	NEXT2		;if not, skip count
COUNT:	TEST	BL,11B		;are we at beginning of line or in a '*' line?
	JNZ	LOOP		;if yes, loop and omit
	INC	DX		;otherwise count the blank/tab
	JMP	SHORT STORE	;and store it
NEXT2:	CMP	AL,13		;CR?
	JZ	OUT		;if yes go to end of line routine
NEXT3:	CMP	AL,10		;LF?
	JNZ	NEXT4		;if not, go on checking
	OR	BL,01000000B	;set end of line bit
	JMP	SHORT OUT	;and go to end of line routine
NEXT4:	TEST	BL,1		;have we seen any non blank/tab char before?
	JZ	NEXT6		;if yes, ignore the next step
	CMP	AL,42		;a '*'?
	JNZ	NEXT5		;if not' skip
	OR	BL,10B		;otherwise set the '*'-bit
NEXT5:	AND	BL,11111110B	;and in either case we have non blank/tab char
NEXT6:	XOR	DX,DX		;set blank/tab count to 0
OUT:	TEST	BL,11B		;are we at beginning of line or in a '*'-line?
	JNZ	LOOP		;if so, ignore (includes CR/LF of blank lines)
	SUB	DI,DX		;DX is non-zero only if we encountered a CR
	XOR	DX,DX		;reset DX to 0
	AND	BL,01111111B	;reset ';'-bit
CAPS0:	JMP 	SHORT CAPS	;capitalize
STORE:	STOSB			;store char
LOOP:	CMP	AL,26		;test for end of file
	LOOPNZ	SCAN0		;and loop for next fetch
	PUSH	AX		;save registers
	PUSH	BX
	PUSH	DX
	MOV	DX,OFFSET DATA	;compute the numbers of bytes stored
	MOV	CX,DI
	SUB	CX,DX		;in CX, and 
	MOV	BX,01		;write to standard output
	MOV	AH,40H		;with DOS function call
	INT	21H
	POP	DX
	POP	BX
	POP	AX
	CMP	AL,26		;end of file?
	JZ	DONE
	JMP	LOAD		;if not, read another 64K bytes
DONE:	INT	20H		;end program
;
CAPS:	CMP	AL,39		;single quote?
	JNZ	QUOT		;if not check double quote
	TEST	BL,100000B	;is double quote bit set?
	JNZ	STORE		;if yes, ignore
	XOR	BL,010000B	;(re-)set single quote bit
	JMP	SHORT STORE
QUOT:	CMP	AL,34		;double quote?
	JNZ	CAPS01		;if not, skip
	XOR	BL,00100000B	;(re-)set double-quote bit
	JMP	SHORT STORE
CAPS01:	TEST	BL,00110000B	;any quote-bits set?
	JNZ	STORE		;if so, don't capitalize
CAPS1:	CMP	AL,97		;below 'a'?
	JB	STORE		;if so, leave it alone
CAPS2:	CMP	AL,122		;above 'z'?
	JA	STORE		;if so, don't change
CAPS3:	AND	AL,5FH		;otherwise capitalize
OUT2:	JMP	SHORT STORE
START	ENDP
DATA:
COMSEG	ENDS
	END	START
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  