/*---------------------------------------------------------------
   XTYPE.C -- Demonstrates multiple threads of execution in OS/2
              (C) 1988, Ziff-Davis Communications Company
              PC Magazine * Programmed by Charles Petzold, 11/87
  ---------------------------------------------------------------*/

#include <doscalls.h>
#include <subcalls.h>

void far KeyWatchThread (void) ;

main (argc, argv)
     int  argc ;
     char *argv [] ;     {
     unsigned char ThreadStack [1024] ;
     char far      *Buffer ;     
     unsigned int  Handle, Action, Selector,
                   ThreadID, BytesRead, BytesWritten ;

     if (argc < 2)
          {
          puts ("Syntax: XTYPE filename") ;
          return 1 ;
          }

     if (DOSCREATETHREAD (KeyWatchThread, &ThreadID, ThreadStack + 1024))
          {
          puts ("XTYPE: Could not create thread") ;
          return 1 ;
          }

     if (DOSALLOCSEG (65535, &Selector, 0))
          {
          puts ("XTYPE: Cannot allocate memory for buffer") ;
          return 1 ;
          }

     Buffer = (char far *) ((long) Selector << 16) ;

     if (DOSOPEN (argv [1], &Handle, &Action, 0L, 0, 1, 0x20, 0L))
          {
          puts ("XTYPE: File not found or cannot be opened") ;
          DOSFREESEG (Selector) ;
          return 0 ;
          }

     DOSREAD (Handle, Buffer, 65535, &BytesRead) ;

     while (BytesRead > 0)
          {
          DOSWRITE (1, Buffer, BytesRead, &BytesWritten) ;

          DOSREAD (Handle, Buffer, 65535, &BytesRead) ;
          }

     DOSCLOSE (Handle) ;
     DOSFREESEG (Selector) ;
     return 0 ;
     }

void far KeyWatchThread ()
     {
     struct KeyData kd ;

     while (1)
          {
          KBDCHARIN (&kd, 0, 0) ;
          DOSSUSPENDTHREAD (1) ;

          KBDCHARIN (&kd, 0, 0) ;

          DOSRESUMETHREAD (1) ;
          }
     }
