        name    td
        title   TD.ASM --- time & date formatting
        page    55,132
;
; TD.ASM --- Time and Date Formatting Functions
;
; Copyright (C) 1988 Ziff Communications Co.
; Ray Duncan * PC Magazine
;
; This module contains six public routines:
;
; TCVT          convert time to ASCII
; DCVT          convert date to ASCII
;
; SYSTCVT       convert current time to ASCII
; SYSDCVT       convert current date to ASCII
;
; DIRTCVT       convert time in directory format to ASCII
; DIRDCVT       convert date in directory format to ASCII
;

DGROUP  group   _DATA


_DATA   segment word public 'DATA'

cbuff   db      34 dup (0)      ; current country info
dbuff   db      8  dup (' ')    ; date formatting buffer
tbuff   db      11 dup (' ')    ; time formatting buffer

                                ; filled in by 'getctry'
doffs   dw      0               ; offset of ASCII day
moffs   dw      0               ; offset of ASCII month
yoffs   dw      0               ; offset of ASCII year

                                ; date format determined
                                ; by Int 21H Func. 38H 
dtab    dw      mdy             ; 0 = USA format
        dw      dmy             ; 1 = Europe format
        dw      ymd             ; 2 = Japan format       

mdy     dw      dbuff+3         ; USA: month day year
        dw      dbuff
        dw      dbuff+6

dmy     dw      dbuff           ; Europe: day month year
        dw      dbuff+3
        dw      dbuff+6

ymd     dw      dbuff+6         ; Japan: year month day
        dw      dbuff+3
        dw      dbuff

_DATA   ends


_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:DGROUP

        public  dcvt            ; make routines available 
        public  tcvt            ; to Linker
        public  systcvt
        public  sysdcvt
        public  dirtcvt
        public  dirdcvt


sysdcvt proc    near            ; format system date
                                ; BX    = length
                                ; DS:SI = buffer
                                ; preserves all registers

        push    ax              ; save registers
        push    bx
        push    cx
        push    dx
        
        mov     ah,2ah          ; func. 2AH = get date
        int     21h             ; transfer to MS-DOS

        call    dcvt            ; convert to ASCII

        pop     dx              ; restore registers
        pop     cx
        pop     bx
        pop     ax

        ret                     ; back to caller

sysdcvt endp


systcvt proc    near            ; format system time
                                ; BX    = length
                                ; DS:SI = buffer
                                ; preserves all registers

        push    ax              ; save registers
        push    bx
        push    cx
        push    dx
        
        mov     ah,2ch          ; func. 2CH = get time
        int     21h             ; transfer to MS-DOS

        call    tcvt            ; convert to ASCII

        pop     dx              ; restore registers
        pop     cx
        pop     bx
        pop     ax

        ret                     ; back to caller

systcvt endp


dirdcvt proc    near            ; format directory date
                                ; AX    = directory date
                                ; BX    = length
                                ; DS:SI = buffer
                                ; preserves all registers

        push    ax              ; save registers
        push    bx
        push    cx
        push    dx
        
        mov     dx,ax           ; isolate months & days
        and     dx,01ffh
        mov     cl,3            ; position month        
        shl     dx,cl
        shr     dl,cl           ; position day

        mov     cl,9            ; position year
        shr     ax,cl
        add     ax,1980
        mov     cx,ax

        call    dcvt            ; convert to ASCII

        pop     dx              ; restore registers
        pop     cx
        pop     bx
        pop     ax

        ret                     ; back to caller

dirdcvt endp


dirtcvt proc    near            ; format directory time
                                ; AX    = directory time
                                ; BX    = length
                                ; DS:SI = buffer
                                ; preserves all registers

        push    ax              ; save registers
        push    bx
        push    cx
        push    dx
        
        mov     dx,ax           ; isolate seconds field
        and     dx,1fh          ; and position it
        mov     cl,9            ; (includes seconds*2)
        shl     dx,cl

        mov     cl,3            ; position hours
        shr     ax,cl

        mov     cl,2            ; position minutes
        shr     al,cl
        mov     cx,ax

        call    tcvt            ; convert to ASCII

        pop     dx              ; restore registers
        pop     cx
        pop     bx
        pop     ax

        ret                     ; back to caller

dirtcvt endp


dcvt    proc    near            ; format ASCII date 
                                ; BX    = length
                                ; CX    = year (1980+)
                                ; DH    = month (1-12)
                                ; DL    = day (1-31)
                                ; DS:SI = buffer
                                ; length clamped to 8
                                ; destroys AX BX CX DX

        cmp     bx,8            ; make sure length OK
        jle     dcvt1
        mov     bx,8            ; too long, use 8 max

dcvt1:  push    es              ; save registers
        push    di
        push    si
        push    bx

        call    getctry         ; get country info

        mov     si,moffs        ; convert month
        mov     al,dh
        call    b2dec   

        mov     si,doffs        ; convert day
        mov     al,dl
        call    b2dec

        mov     si,yoffs        ; convert year, 
        sub     cx,1900         ; corrected to 80-99
        mov     al,cl
        call    b2dec

        mov     ax,ds           ; transfer ASCII date
        mov     es,ax           ; to caller's buffer
        mov     si,offset DGROUP:dbuff
        pop     cx              ; buffer length
        pop     di              ; buffer address
        push    di
        rep movsb               ; copy string

        pop     si              ; restore registers     
        pop     di
        pop     es

        ret                     ; return to caller

dcvt    endp

                                         
tcvt    proc    near            ; format ASCII time
                                ; BX    = length
                                ; CH    = hour
                                ; CL    = minute
                                ; DH    = second
                                ; DL    = hundredths
                                ; DS:SI = buffer
                                ; length clamped to 11
                                ; destroys AX BX CX DX

        cmp     bx,11           ; make sure length OK
        jle     tcvt1
        mov     bx,11           ; too long, use 11 max

tcvt1:  push    es              ; save registers
        push    di
        push    si
        push    bx

        call    getctry         ; get country info

        mov     al,ch           ; convert hours
        mov     si,offset DGROUP:tbuff
        call    b2dec

        mov     al,cl           ; convert minutes
        add     si,3
        call    b2dec

        mov     al,dh           ; convert seconds
        add     si,3
        call    b2dec

        mov     al,dl           ; convert hundredths
        add     si,3
        call    b2dec

        mov     ax,ds           ; transfer ASCII time
        mov     es,ax           ; to caller's buffer
        mov     si,offset DGROUP:tbuff
        pop     cx              ; buffer length
        pop     di              ; buffer address
        push    di
        rep movsb               ; copy string

        pop     si              ; restore registers     
        pop     di
        pop     es

        ret                     ; return to caller

tcvt    endp


b2dec   proc    near            ; convert binary 0-99
                                ; to two ASCII digits.
                                ; AL    = value
                                ; DS:SI = storage address
                                ; destroys AX 

        aam                     ; divide AL by 10 ->
                                ; AH = quot., AL = rem.

        add     ax,'00'         ; convert to ASCII
        xchg    ah,al
        mov     [si],ax         ; and store digits

        ret                     ; back to caller

b2dec   endp


getctry proc    near            ; get country information

        test    doffs,-1        ; did we already get info?
        jnz     getc4           ; if we did, just exit
        
        push    ax              ; save registers
        push    bx              ; (in case destroyed by
        push    cx              ;  Int 21H Function 38H)
        push    dx

        mov     ax,3000h        ; Fxn. 30h = get DOS vers.
        int     21h             ; transfer to MS-DOS

        or      al,al           ; is it version 1.x?
        jz      getc1           ; yes, jump

        push    ax              ; save MS-DOS version

        mov     ax,3800h        ; get current country info
        mov     dx,offset DGROUP:cbuff
        int     21h             ; transfer to MS-DOS

        pop     ax              ; restore MS-DOS version
        jc      getc1           ; jump if get cntry failed

        cmp     al,3            ; is it version 3.x?
        jne     getc2           ; jump if version 2

                                ; MS-DOS version 3...
        mov     al,cbuff+9      ; get decimal separator
        mov     bh,cbuff+11     ; get date separator
        mov     bl,cbuff+13     ; get time separator
        jmp     getc3

getc1:                          ; version 1.x or get
                                ; country info failed,
                                ; force date format=mdy
        mov     word ptr cbuff,0

getc2:                          ; versions 1.x and 2.x, 
        mov     al,'.'          ; force decimal separator
        mov     bh,'/'          ; force date separator
        mov     bl,':'          ; force time separator

getc3:  mov     tbuff+8,al      ; store decimal separator

        mov     tbuff+2,bl      ; store time separators
        mov     tbuff+5,bl

        mov     dbuff+2,bh      ; store date separators
        mov     dbuff+5,bh

                                ; set date field offsets
                                ; using country info    
        mov     bx,word ptr cbuff
        shl     bx,1            ; date code*2=dtab index
        mov     bx,[bx+dtab]
        mov     ax,[bx]         ; offset for ASCII day
        mov     doffs,ax
        mov     ax,[bx+2]       ; offset for ASCII month
        mov     moffs,ax
        mov     ax,[bx+4]       ; offset for ASCII year
        mov     yoffs,ax

        pop     dx              ; restore registers
        pop     cx
        pop     bx
        pop     ax

getc4:  ret                     ; back to caller

getctry endp


_TEXT   ends


        end
