PROGRAM Rename_with_space;

{ NOTE: This is a Turbo Pascal 4.0 program, but you can convert
  it for TP3 easily enough.  There are two places you have to
  change, both marked with "(*TP3*)".  Look for that marker and
  follow the instructions.}

(*TP3*)(*Delete the next two lines for use with TP3*)
{$R-,S-,I-,D-,T-,F-,V-,B-,N-}
{$M 1024,0,0 }
TYPE
  commandstr = STRING[127];
VAR
  commandLine,
  oldname, newname : commandstr;
  pstart, pend     : Byte;
  F                : FILE;

  PROCEDURE Error_Out;
  BEGIN
    WriteLn('SYNTAX: RENDIR "oldname" "newname"');
    WriteLn('The quotes around the two names are REQUIRED.');
    Halt;
  END;

BEGIN
  commandline := commandStr(Ptr(PrefixSeg, $80)^);
  (*TP3*)(*To use with TP3, comment out the line above and
           UN-comment out the line below*)
(*  Move(MEM[CSeg:$80], commandline, 128);*)
  pstart := Pos('"', commandline);  IF pstart = 0 THEN error_Out;
  commandline[pstart] := ' ';
  pend := Pos('"', commandline);    IF pend = 0 THEN error_Out;
  commandline[pend] := ' ';
  (*The old name is the text between the first pair of "s*)
  oldname := Copy(commandline, Succ(pstart), Pred(pend-pstart));
  pstart := Pos('"', commandline);  IF pstart = 0 THEN error_Out;
  commandline[pstart] := ' ';
  pend := Pos('"', commandline);    IF pend = 0 THEN error_Out;
  commandline[pend] := ' ';
  (*The new name is the text between the second pair of "s*)
  newname := Copy(commandline, Succ(pstart), Pred(pend-pstart));
  Assign(F, oldname);
  Rename(F, newname);
  IF IOResult = 0 THEN
    WriteLn('Successfully renamed "', oldname, '" to "', newname, '"')
  ELSE
    WriteLn('Unable to rename "', oldname, '" to "', newname, '"');
END.

