TITLE     'ENETBIOS - resident program to display NETBIOS commands
;----------------------------------------------------------------------
;  This program will get the second byte (NCB command field) and
;   compare this field against the fn_table. If there is a match then
;   the message which corresponds with the byte is diplayed on the CRT.
;
;   The display starts at column 45 and ranges between lines 0 and 23.
;   When the line reaches the bottom it starts at the top leaving an
;   audit trail which can help you in determining NETBIOS problems.
;----------------------------------------------------------------------
CSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
        ORG     100H
START:
        JMP   INITIALIZE

COPYRIGHT	DB	"ENETBIOS 1.00 (c) Ziff Communications Co.",13,10
		DB	"PC Magazine ",254," Randol Tigrett","$",26

OLD_NETBIOS       DD ?                           ;store old interrupt
NCBLINE           DB 2 DUP (10)                  ;save current line
;----------------------------------------------------------------------
;  fn_table - table contains the actual NETBIOS Control Block command
;  field.
;  The fn_table will be mapped against the message table to produce the
;  right request to be displayed on the CRT
;----------------------------------------------------------------------

FN_TABLE        DB      00H, 01H, 03H, 05H, 06H, 08H, 09H, 0AH, 0BH
                DB      0DH, 0EH, 0FH, 011H, 012H, 013H, 014H, 015H, 016H
                DB      017H, 018H, 019H, 01AH, 021H, 022H, 023H, 024H, 026H
                DB      0FFH, 04FH, 05FH
LEN_FN_TABLE    EQU     $-OFFSET FN_TABLE

;----------------------------------------------------------------------
;  message table of NETBIOS Control Block commands
;----------------------------------------------------------------------
MSG_TABLE       LABEL   BYTE

DB "Good Return Code",0,"Invalid Buffer Length",0,"Illegal Command Code",0
db "Command Time-out",0,"Message Buffer Too Small",0
db "Session Number Not Active",0,"No Space In Adapter",0,"Session Is Closed",0
db "Command Was Canceled",0,"Duplicate Name In Local Table",0
Db "Local Name Table Is Full",0,"Deleted Name Is Active",0
Db "Local Session Table Is Full",0,"Listen Not Outstanding On Remote CPU",0
Db "Illegal Name Number",0,"Cannot Find Name / No Answer",0
Db "Name Not Found In Local Table",0,"Name In Use Elsewhere",0
Db "Name Deleted / No Outstanding Commands",0,"Session Ended Abnormally",0
Db "Netbios Two Or More Active Names",0
Db "Incompatible Packet Protocol Received",0,"Interface Busy",0
Db "Too Many Commnads Outstanding",0,"Bad NCB_LANA_NUM Field",0
Db "Cancel Request / No Pending Commands",0,"Command Is Illegal To Cancel",0
Db "Command Is Still Pending",0,"Undeterminable Network Error",0
Db "Adapter Has Malfunctioned",0

;----------------------------------------------------------------------
;  Intercept the NETBIOS call and display what call was made.
;----------------------------------------------------------------------
NETBIOS_INT       PROC    FAR
        ASSUME  CS:CSEG,DS:NOTHING,ES:NOTHING,SS:NOTHING

        STI
        PUSHF
        CALL    OLD_NETBIOS                     ;call 5CH interrupt
                                                ; for processing
        CALL    LOAD_MSG                        ;get network control
                                                ; block command and
                                                ;display message
        IRET                                    ;return from interrupt

NETBIOS_INT       ENDP

;----------------------------------------------------------------------
;  Look up the function number in the table and get English equivalent.
;----------------------------------------------------------------------
LOAD_MSG          PROC    NEAR
        ASSUME  CS:CSEG, DS:NOTHING, ES:NOTHING, SS:NOTHING

                PUSH    AX                       ;save registers
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    SI
                PUSH    DI
                PUSH    BP
                PUSH    DS
                PUSH    ES

                PUSH    CS
                POP     DS
        ASSUME  DS:CSEG                         ;Tell the assembler
                MOV     AH,BYTE PTR ES:[BX+1]   ;Get network control
                                                ;block return code
                MOV     SI,OFFSET FN_TABLE      ;Source of numbers
                MOV     CX,LEN_FN_TABLE         ;Quantity to search

;----------------------------------------------------------------------
;  Routine to find network error or bad adapter
;----------------------------------------------------------------------
                CMP     AH,03FH
                JLE     LM_0
                CMP     AH,04FH                 ;undetermined network
                JG      LM_5F                   ;error?
                MOV     AH,04FH
LM_5F:
                CMP     AH,0FEH                 ;adapter malfunction ?
                JG      LM_0
                MOV     AH,05FH
LM_0:
                LODSB                           ;Get function number in AL
                CMP     AH,AL                   ;Match?
                JE      LM_1                    ;Yes, translate
                LOOP    LM_0                    ;No, loop again
                JMP     LM_EXIT                 ;No match found

;----------------------------------------------------------------------
;  Found a matching function. Use msg # total_msgs - cx
;----------------------------------------------------------------------
LM_1:
                MOV     AH,CL
                MOV     CX,LEN_FN_TABLE
                MOV     SI,OFFSET MSG_TABLE     ;Source of messages
LM_2:
                CMP     AH,CL                   ;Does msg count = target?
                JE      LM_4                    ;Yes, go print
LM_3:
                LODSB                           ;Get char
                OR      AL,AL                   ;If not 0
                JNZ     LM_3                    ; keep scanning
                LOOP    LM_2                    ; and try for match
LM_4:
;----------------------------------------------------------------------
;  SI points at the start of the message.
;----------------------------------------------------------------------
                MOV     AH,03                   ;read cursor position
                MOV     BH,0
                INT     10H
                PUSH    DX                      ;Save row/col

                MOV     AH,02                   ;Set cursor position
                MOV     DL,45                   ;at column 45

;----------------------------------------------------------------------
;  increment the display line for command audit : up to 23 lines
;----------------------------------------------------------------------
                MOV     DH,NCBLINE               ;move line variable
                                                 ;into dh
                INC     DH                       ;add 1 to next line
                CMP     DH,23                    ;is line >= 23 ?
                JLE     SHORT LM_P               ;yes then line = 0
                MOV     DH,0
LM_P:
                MOV     NCBLINE,DH               ;save line number
                MOV     BH,0
                INT     10H
                MOV     AX,0920H                 ;clear display area
                XOR     BH,BH
                MOV     BL,31H
                MOV     CX,35
                INT     10H
LM_5:
                LODSB                            ;load message string
                OR      AL,AL                    ;end of string ?
                JZ      LM_6                     ;yes jump lm_6
                MOV     AH,0EH                   ;write character
                INT     10H
                JMP     LM_5                     ;anymore characters ?
LM_6:
                MOV     AH,02                   ;Set cursor position
                MOV     DL,45                   ;at column 45
                INC     DH                      ;check next line
                CMP     DH,23                   ;next line >= 23 ?
                JLE     SHORT LM_P1             ;yes, line = 0
                MOV     DH,0
LM_P1:
                XOR     BH,BH
                INT     10H

                MOV     AX,0920H                 ;clear next line
                MOV     BL,31H                   ;make line blue
                MOV     CX,35                    ;clear all attributes
                INT     10H                      ;up to 35 spaces

                POP     DX                       ;restore cursor location
                MOV     AH,02
                MOV     BH,0
                INT     10H
LM_EXIT:
                POP     ES                       ;restore registers
                POP     DS
                POP     BP
                POP     DI
                POP     SI
                POP     DX
                POP     CX
                POP     BX
                POP     AX

                RET

LOAD_MSG          ENDP

;======================================================================
;  Grab the interrupt vector.
;----------------------------------------------------------------------
INITIALIZE:
        ASSUME  CS:CSEG,DS:CSEG

        MOV     AL,5CH                           ;get netbios interrupt
        MOV     AH,35H
        INT     21H
        MOV     WORD PTR OLD_NETBIOS,BX          ;store netbios interrupt
        MOV     WORD PTR OLD_NETBIOS[2],ES
        MOV     DX,OFFSET NETBIOS_INT            ;replace netbios interrupt
                                                 ;with start of program
        MOV     AL,5CH
        MOV     AH,25H
        INT     21H

        MOV     DX,(OFFSET INITIALIZE - OFFSET CSEG + 15 ) SHR 4
	MOV	AX,3100H
	INT	21H

CSEG    ENDS
        END     START
