        name    tryqsi
        title   TRYQSI Demo of Integer Quicksort
        page    55,132
;
; TRYQSI.ASM    Demonstration of Integer Quicksort
;
; Copyright 1988, Ziff Communications Co.
; PC Magazine * Ray Duncan
;

stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle
stderr  equ     2               ; standard error handle

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   itoa:near
        extrn   atoi:near
        extrn   qsorti:near

main    proc    near

        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax

main1:                          ; begin entry of data

        mov     word ptr ix1,0  ; initialize array index
        
                                ; display "Enter Numbers"
        mov     dx,offset msg1  ; DS:DX = message address
        mov     cx,msg1_len     ; CX = message length
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

main2:                          ; convert item number
                                ; to ASCII string...
        mov     ax,ix1          ; 1-based item number
        inc     ax
        mov     bx,offset msg3a ; address for string
        call    b2dec           ; convert it

                                ; display item number
        mov     dx,offset msg3  ; DS:DX = message address
        mov     cx,msg3_len     ; CX = length
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

                                ; read keyboard entry
        mov     dx,offset ibuff ; DS:DX = input buffer
        mov     cx,80           ; CX = max input length
        mov     bx,stdin        ; BX = handle
        mov     ah,3fh          ; Fxn 3FH = read
        int     21h             ; transfer to MS-DOS

        cmp     ax,2            ; was anything entered?
        je      main3           ; empty line, exit

        mov     si,offset ibuff ; convert input to
        call    atoi            ; binary in reg. AX
                                        
        mov     bx,ix1          ; put data into array
        shl     bx,1            ; (item number * 2)
        mov     [bx+items],ax

        inc     word ptr ix1    ; count items stored
        cmp     word ptr ix1,25 ; force maximum = 25

        jne     main2           ; get another entry

main3:                          ; empty line entered...

        cmp     word ptr ix1,0  ; any data in array?
        je      main5           ; no, just exit

                                ; otherwise sort data...
        mov     si,offset items ; DS:SI = first item
        mov     di,ix1          ; DS:DI = last item
        dec     di
        shl     di,1
        add     di,si
        call    qsorti          ; call QuickSort

                                ; display sorted data...

        mov     word ptr ix2,0  ; initialize array index

                                ; display "Here are the
                                ; sorted numbers..."
        mov     dx,offset msg2  ; DS:DX = message address
        mov     cx,msg2_len     ; CX = message length
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

main4:                          ; display next item...

                                ; convert item number
                                ; to ASCII string
        mov     ax,ix2          ; 1-based item number
        inc     ax              
        mov     bx,offset msg3a ; address for string
        call    b2dec           ; convert it

                                ; display item number
        mov     dx,offset msg3  ; DS:DX = message address
        mov     cx,msg3_len     ; CX = message length
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

        mov     bx,ix2          ; calc. array offset
        shl     bx,1
        mov     ax,[bx+items]   ; get data from array

                                ; convert data to ASCII
        mov     cx,10           ; use base 10
        mov     si,offset obuff ; address for string
        call    itoa            ; convert it

                                ; display converted data...
        mov     cx,ax           ; CX = string length
        mov     dx,si           ; DS:DX = string address 
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

        inc     word ptr ix2    ; advance through array

        mov     ax,ix2          ; done with array yet?
        cmp     ax,ix1
        jne     main4           ; no, display another

        jmp     main1           ; restart user entry

main5:  mov     ax,4c00h        ; final exit to MS-DOS
        int     21h

main    endp


b2dec   proc    near            ; convert binary value 0-99
                                ;  to decimal ASCII chars.
                                ; call with 
                                ; AL = binary data
                                ; BX = addr. for 2 chars.
        
        aam                     ; divide AL by 10, leaving
                                ; AH=quotient, AL=remainder
        add     ax,'00'         ; convert to ASCII
        mov     [bx],ah         ; store ten's digit
        mov     [bx+1],al       ; store one's digit
        ret                     ; return to caller

b2dec   endp

_TEXT   ends


_DATA   segment word public 'DATA'

msg1    db      cr,lf,lf
        db      'Enter numbers to sort...'
        db      cr,lf
msg1_len equ $-msg1

msg2    db      cr,lf
        db      'Here are the sorted numbers...'
        db      cr,lf
msg2_len equ $-msg2

msg3    db      cr,lf,'Item '
msg3a   db      'xx: '
msg3_len equ $-msg3

ibuff   db      80 dup (?)      ; keyboard input buffer

obuff   db      80 dup (?)      ; output conversion buffer

items   dw      25 dup (0)      ; holds numbers to sort

ix1     dw      0               ; number of array items 
ix2     dw      0               ; array output pointer

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends

        end     main
