;  XpanBoss: the control program for the XPANDISK.SYS
;  virtual disk expanded memory device driver. PC Magazine 10-31-88

_TEXT          SEGMENT PUBLIC 'CODE'
               ASSUME  CS:_TEXT,DS:_TEXT
               ASSUME  ES:_TEXT,SS:_TEXT
               ORG     100H

START:         JMP     MAIN

COPYRIGHT      DB      CR,LF,"XPANBOSS 1.0 (C) 1988 Ziff Communications Co."
PROGRAMMER     DB      CR,LF,"PC Magazine ",BOX," Michael J. Mefford",CR,LF,LF

DB "Syntax: XPANBOSS [d:][/D disk size][/S sector size][/E entries]"
DB "[/W][/R][/M][/A]",CR,LF,LF
DB "disk size   = (16 - 32768)K bytes; default = 64",CR,LF
DB "sector size = (128,256,512) bytes; default = 256",CR,LF
DB "entries     = (4 - 512)in root directory; default = 64",CR,LF
DB "/W = Change size WITHOUT asking. WARNING: All data will be lost.",CR,LF
DB "/R = Read-only drive",CR,LF
DB "/M = Minimum disk size (16K)",CR,LF
DB "/A = All of available expanded memory",CR,LF,LF

DB "Use XPANBOSS to control the XPANDISK virtual disk",CR,LF,"$"

BELL           EQU     7
CR             EQU     13
LF             EQU     10
CTRL_Z         EQU     26
SPACE          EQU     32
BOX            EQU     254
Y_SCAN         EQU     15H

DRIVE          EQU     5CH

PASSWORD               DB      "PC Magazine Productivity"
PASSWORD_LENGTH        EQU     $ - PASSWORD
PIPE                   DB      PASSWORD_LENGTH + 1 DUP (?)

DRIVE_MSG      DB      "Drive $"
ILLEGAL_MSG    DB      ": does not belong to XPANBOSS",BELL,CR,LF,"$"
WARNING_MSG1   DB      CR,LF,"WARNING: All current data of $"
WARNING_MSG2   DB      ": will be lost.",CR,LF
               DB      "Do you wish to continue?  Y/N $"
FAILED_MSG     DB      "UNSUCCESSFUL"
CRLF           DB      CR,LF,"$"

;----------------------------------------------------------------------
MAIN           PROC    NEAR

               CLD                             ;All string moves forward.
               MOV     DX,OFFSET COPYRIGHT     ;Display copyright.
               CALL    PRINT_STRING

               MOV     BL,DS:[DRIVE]           ;Retrieve drive request.
               MOV     AL,BL                   ;Save it.
               DEC     AL                      ;Was there a drive request?
               JNS     GOT_DRIVE               ;If yes, use it.

               MOV     AH,19H                  ;Else, get default drive.
               INT     21H

GOT_DRIVE:     ADD     AL,"A"                  ;Convert to ASCII.
               MOV     DS:[DRIVE],AL                  ;Save it and
               MOV     BYTE PTR DS:[DRIVE + 1],"$"    ; convert to DOS string.

               MOV     DX,OFFSET PIPE          ;Request password from
               MOV     SI,DX                   ; block device driver.
               MOV     CX,PASSWORD_LENGTH
               MOV     AX,4404H                ;IOCTL Read from block device.
               INT     21H

               MOV     DI,OFFSET PASSWORD      ;Did device driver return
               REPZ    CMPSB                   ; required password?
               JZ      CONTINUE                ;If yes, continue.

               MOV     DX,OFFSET CRLF          ;Else, CR and LF to next line.
               CALL    PRINT_STRING
               CALL    PRINT_DRIVE             ;Print requested drive.
               MOV     DX,OFFSET ILLEGAL_MSG   ;Tell user drive does not
               CALL    PRINT_STRING            ; belong to XPANBOSS.
               JMP     SHORT ERROR_EXIT

CONTINUE:      CMP     BYTE PTR [SI],0         ;If Parameters not changed
               JZ      PARAMETERS              ; or /W, skip warning.

               CALL    WARNING                 ;Else, warn user.
               JNZ     EXIT                    ;Exit if user said no.
               MOV     DX,OFFSET CRLF          ;Else, CR, LF to next line.
               CALL    PRINT_STRING

PARAMETERS:    MOV     DX,OFFSET PASSWORD      ;Send counter password as
               MOV     CX,PASSWORD_LENGTH      ; OK to XPANDISK.
               MOV     AX,4405H                ;IOCTL Write to block device.
               INT     21H
               MOV     AL,0                    ;ERRORLEVEL = 0.
               JNC     EXIT                    ;If successful, exit.

               MOV     DX,OFFSET FAILED_MSG    ;Else, tell user it failed.
               CALL    PRINT_STRING
ERROR_EXIT:    MOV     AL,1                    ;ERRORLEVEL = 1.

EXIT:          PUSH    AX                      ;Save ERRORLEVEL.
               MOV     DX,OFFSET CRLF          ;Blank line.
               CALL    PRINT_STRING
               POP     AX                      ;Retrieve ERRORLEVEL.
               MOV     AH,4CH                  ;Exit.
               INT     21H

MAIN           ENDP

WARNING:       MOV     DX,OFFSET WARNING_MSG1  ;Display warning message.
               CALL    PRINT_STRING
               CALL    PRINT_DRIVE
               MOV     DX,OFFSET WARNING_MSG2
               CALL    PRINT_STRING

               XOR     AH,AH                   ;Get a keystroke.
               INT     16H
               CMP     AH,Y_SCAN               ;"Y" key pressed?
               JNZ     WARNING_END             ;If no, quick exit.
               MOV     AH,0EH                  ;Else, display key pressed.
               INT     10H
               XOR     AH,AH                   ;Retrieve another keystroke.
               INT     16H
               CMP     AL,CR                   ;Requires a confirming Enter.

WARNING_END:   RET

PRINT_DRIVE:   MOV     DX,OFFSET DRIVE_MSG
               CALL    PRINT_STRING
               MOV     DX,5CH                  ;Requested drive.

PRINT_STRING:  MOV     AH,9
               INT     21H
               RET

_TEXT          ENDS
               END     START
