;----------------------------------------------------------------------
; STRINGS1.ASM --- MASM String Package #1
;
; Copyright (c) 1988, Ziff Communications Co.
; PC Magazine * Ray Duncan * November 15, 1988
;----------------------------------------------------------------------
_TEXT   segment word public 'CODE'
        assume  cs:_TEXT

;----------------------------------------------------------------------
; STRCMP: General purpose string comparison routine
;
; Call with:    DS:SI = address of string1
;               BX    = length of string1
;               ES:DI = address of string2
;               DX    = length of string2
;
; Returns:      Z     = True  if strings are equal
;               or
;               Z     = False if strings are not equal, and
;               S     = True  if string1 < string2
;               S     = False if string1 > string2
;----------------------------------------------------------------------
        public  strcmp
strcmp  proc    near

        mov     cx,dx           ; set length to compare

        cmp     bx,dx           ; use shorter of two lengths
        ja      scmp1           ; jump if string1 longer

        mov     cx,bx           ; string1 is shorter

scmp1:  repz cmpsb              ; now compare strings
        jz      scmp2           ; jump, strings equal so far

        ret                     ; return Z=F, strings not equal

scmp2:  sub     bx,dx           ; compare original string lengths
        ret                     ; return with S and Z flags set 

strcmp  endp

;----------------------------------------------------------------------
; STRNDX: General purpose string search routine
;
; Call with:    DS:SI = pattern address
;               BX    = pattern length 
;               ES:DI = address of string to be searched
;               DX    = length of string to be searched
;
; Returns:      CY    = True if no match 
;               or
;               CY    = False if match, and 
;               ES:DI = pointer to match for pattern
;                       string within searched string
;----------------------------------------------------------------------
        public  strndx
strndx  proc    near

        mov     bp,si           ; save pattern offset
        dec     bx              ; decr. pattern length by one
        cld

sndx1:  mov     si,bp           ; AL := first char of pattern
        lodsb
        mov     cx,dx           ; remaining searched string length
        repnz scasb             ; look for match on first char.

        jnz     sndx3           ; searched string exhausted, exit

        mov     dx,cx           ; save new string length
        mov     cx,bx           ; get pattern length - 1
        repz cmpsb              ; compare remainder of strings

        jz      sndx2           ; everything matched

        add     di,cx           ; no match, restore string addr
        sub     di,bx           ; advanced by one char.

        cmp     dx,bx           ; searched string exhausted?
        ja      sndx1           ; some string left, try again
        jmp     sndx3           ; no match, jump to return 

sndx2:  sub     di,bx           ; match found, let
        dec     di              ; ES:DI = matched string addr.
        clc                     ; and return CY=False
        ret

sndx3:  stc                     ; no match, return CY=True
        ret

strndx  endp

;----------------------------------------------------------------------
; STRSPN: General purpose string validation routine
;
; Call with:    DS:SI = text string to be validated
;               BX    = length of text string
;               ES:DI = validation string
;               DX    = length of validation string
;
; Returns:      CY    = False if text string valid
;               or
;               CY    = True if text string invalid, and
;               DS:SI = pointer to invalid character
;                       within text string
;----------------------------------------------------------------------
        public  strspn
strspn  proc    near

        mov     cx,bx           ; CX = length of text string
        jcxz    sspn5           ; exit if no text string 

        or      dx,dx           ; exit if no validation string
        jz      sspn3

sspn1:  lodsb                   ; get next text string char.
        xor     bx,bx           ; BX is validation string index

sspn2:  cmp     al,es:[bx+di]   ; compare to validation string
        je      sspn4           ; this character is OK

        inc     bx              ; bump validation string addr.
        cmp     bx,dx           ; end of validation string yet?
        jne     sspn2           ; no, check next position
                                
        dec     si              ; yes, point to bad character

sspn3:  stc                     ; return CY flag true and
        ret                     ; DS:SI = bad character

sspn4:  loop    sspn1           ; count text string characters
                                ; and check the next one

sspn5:  clc                     ; all characters were OK
        ret                     ; return CY flag false

strspn  endp

;----------------------------------------------------------------------
; STRBRK: General purpose character set search routine
;
; Call with:    DS:SI = text string to search
;               BX    = length of text string
;               ES:DI = character list to search for
;               DX    = length of character list
;
; Returns:      CY    = False if no matching characters
;                       in text string
;               or
;               CY    = True if matching character found
;                       in text string, and 
;               DS:SI = matched character within text string
;----------------------------------------------------------------------
        public  strbrk
strbrk  proc    near

        or      bx,bx           ; check text length
        jz      sbrk3           ; exit if no text string 

        or      dx,dx           ; check list length
        jz      sbrk3           ; exit if no list

sbrk1:  lodsb                   ; get next text string char.
        mov     cx,dx           ; CX = list length
        repnz scasb             ; scan the character list
        jnz     sbrk2           ; jump if no chars. matched

        dec     si              ; point to matching char.
        stc                     ; return CY flag True
        ret                     ; and DS:SI = matched char.

sbrk2:  sub     di,dx           ; reset char. list address
        dec     bx              ; count list characters
        jnz     sbrk1           ; loop, not end of list
        
sbrk3:  clc                     ; no matching characters,
        ret                     ; return CY flag false

strbrk  endp

_TEXT   ends
        
        end
