;----------------------------------------------------------------------
; TRYSTR.ASM --- demo of MASM string package
; PC Magazine * Ray Duncan * November 15, 1988
;----------------------------------------------------------------------
cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed

stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle
stderr  equ     2               ; standard error handle

DGROUP  group   _DATA

_DATA   segment word public 'DATA'

str1    db      80 dup (0)      ; string 1 buffer
str2    db      80 dup (0)      ; string 2 buffer

s1len   dw      ?               ; string 1 length
s2len   dw      ?               ; string 2 length

msg1    db      cr,lf,lf        
        db      'Enter string 1:  '
msg1_len equ $-msg1

msg2    db      cr,lf
        db      'Enter string 2:  '
msg2_len equ $-msg2

msg3    db      cr,lf
        db      'String 1 at: '
msg3a   db      '????H'
        db      cr,lf
        db      'String 2 at: '
msg3b   db      '????H'
        db      cr,lf,lf
        db      'STRCMP: Z='
msg3c   db      '? S='
msg3d   db      '?'
        db      cr,lf
        db      'STRNDX: CY='
msg3e   db      '? DI='
msg3f   db      '????H'
        db      cr,lf
        db      'STRSPN: CY='
msg3g   db      '? SI='
msg3h   db      '????H'
        db      cr,lf
        db      'STRBRK: CY='
msg3i   db      '? SI='
msg3j   db      '????H'
msg3_len equ $-msg3

_DATA   ends


_TEXT   segment word public 'CODE'

        extrn   strcmp:near
        extrn   strndx:near
        extrn   strspn:near
        extrn   strbrk:near
        extrn   itoh:near

        assume  cs:_TEXT,ds:DGROUP

main    proc    near
                                
        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax

        mov     ax,offset str1  ; format string 1
        mov     bx,offset msg3a ; buffer address
        call    itoh            ; for output

        mov     ax,offset str2  ; format string 2
        mov     bx,offset msg3b ; buffer address
        call    itoh            ; for output

main1:                          ; display prompt for string 1...
        mov     dx,offset DGROUP:msg1 ; address of message
        mov     cx,msg1_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS

                                ; get first string...
                                ; address of buffer
        mov     dx,offset DGROUP:str1
        mov     cx,64           ; maximum entry length
        mov     bx,stdin        ; standard input handle
        mov     ah,3fh          ; function 3fh = read
        int     21h             ; transfer to MS-DOS

        sub     ax,2            ; anything entered?
        mov     s1len,ax        ; save string length
        
        jnz     main2           ; jump if something entered

        mov     ax,4c00h        ; exit if empty line
        int     21h             ; transfer to MS-DOS

main2:                          ; display prompt for string 2...
        mov     dx,offset DGROUP:msg2  ; address of message
        mov     cx,msg2_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS

                                ; get second string...
        mov     dx,offset DGROUP:str2   ; address of buffer
        mov     cx,64           ; maximum entry length
        mov     bx,stdin        ; standard input handle
        mov     ah,3fh          ; function 3fh = read
        int     21h             ; transfer to MS-DOS

        sub     ax,2            ; save string length
        mov     s2len,ax

        mov     si,offset str1  ; compare the strings
        mov     bx,s1len
        mov     di,offset str2
        mov     dx,s2len
        call    strcmp          

        call    zflag           ; format Z and S
        mov     msg3c,al        ; flags for output
        call    sflag
        mov     msg3d,al

        mov     si,offset str1  ; search string 2
        mov     bx,s1len        ; for string 1
        mov     di,offset str2
        mov     dx,s2len
        call    strndx

        call    cflag           ; format CY flag
        mov     msg3e,al        ; for output

        mov     ax,di           ; format string 2
        mov     bx,offset msg3f ; pointer for output
        call    itoh

        mov     si,offset str1  ; validate string 1
        mov     bx,s1len        ; using string 2
        mov     di,offset str2
        mov     dx,s2len
        call    strspn

        call    cflag           ; format CY flag
        mov     msg3g,al        ; for output

        mov     ax,si           ; format string 1 
        mov     bx,offset msg3h ; pointer for output
        call    itoh

        mov     si,offset str1  ; find first char
        mov     bx,s1len        ; in string 1 that
        mov     di,offset str2  ; is in string 2
        mov     dx,s2len
        call    strbrk

        call    cflag           ; format CY flag
        mov     msg3i,al        ; for output

        mov     ax,si           ; format string 1
        mov     bx,offset msg3j ; pointer for output
        call    itoh

                                ; display results...
        mov     dx,offset DGROUP:msg3   ; address of message
        mov     cx,msg3_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS

        jmp     main1           ; get more strings

main    endp


zflag   proc    near

        mov     al,'F'
        jnz     zflag1
        mov     al,'T'
zflag1: ret     

zflag   endp


sflag   proc    near

        mov     al,'F'
        jns     sflag1
        mov     al,'T'
sflag1: ret     

sflag   endp

        
cflag   proc    near

        mov     al,'F'
        jnc     cflag1
        mov     al,'T'
cflag1: ret     

cflag   endp
        
_TEXT   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends

        end     main
