DEF FNGetKey$

    'Works like INKEY$, but also returns a repeat count for extended keys.

    STATIC GetKey$, ScanCode%, Mask%, Count%, InArray%(1), OutArray%(1)
    REDIM InArray%(7), OutArray%(7)

    GetKey$ = INKEY$                    'get a keystroke
    FNGetKey$ = GetKey$                 'set up default return value
    IF LEN(GetKey$) <> 2 THEN EXIT DEF  'if null or normal key, exit

    ScanCode% = ASC(RIGHT$(GetKey$, 1)) 'isolate the key's scan code
    Mask% = 8                           'assume it's an Alt-key for now
    Count% = 1                          'assume no repeats for now

    SELECT CASE ScanCode%
       CASE 94 TO 103           '<Ctrl-F1> through <Ctrl-F10>
          Mask% = 4
       CASE 115 TO 119          '<Ctrl-Left>, <Ctrl-Right>, <Ctrl-End>,
          Mask% = 4             '<Ctrl-PgDn>, or <Ctrl-Home>
       CASE 132
          Mask% = 4             '<Ctrl-PgUp>
       CASE ELSE
    END SELECT

    'Wait for additional keystrokes until the user either releases the
    '<Alt> or <Ctrl> key, or hits a different keystroke.

L1: InArray%(0) = &H200

    'Call the BIOS to get the status of the <ALT> and <CTRL> keys.
    CALL INT86(&H16, VARPTR(InArray%(0)), VARPTR(OutArray%(0)))

    'Check the appropriate bit in the AL register.
    IF (Mask% AND OutArray%(0)) = 0 GOTO Done

    'Call the BIOS to see if there is a keystroke waiting in the buffer.
    InArray%(0) = &H100
    CALL INT86(&H16, VARPTR(InArray%(0)), VARPTR(OutArray%(0)))

    'Check the Z flag in the FLAGS register to see if a keystroke is waiting.
    IF (OutArray%(7) AND 64) = 64 GOTO L1

    'Examine AH register to see if keystroke matches the previous scan code.
    IF PEEK(VARPTR(OutArray%(0)) + 1) <> ScanCode% GOTO Done

    'Remove the keystroke from the keyboard buffer and increment the count.
    GetKey$ = INKEY$
    Count% = Count% + 1
    GOTO L1

Done: IF Count% <> 1 THEN FNGetKey$ = GetKey$ + CHR$(Count%)

END DEF

'Test program for FNGetKey$

L2: Key$ = FNGetKey$
    IF Key$ = "" GOTO L2

    SELECT CASE LEN(Key$)
       CASE 1
          PRINT Key$;
       CASE 2
          PRINT "Scan Code: "; ASC(MID$(Key$, 2));
       CASE 3
          PRINT "Scan Code: "; ASC(MID$(Key$, 2)),
          PRINT "Count: "; ASC(RIGHT$(Key$, 1));
    END SELECT
    PRINT
    GOTO L2

