{$R+}
PROGRAM GetASCII;
CONST
  buffsize = 16384;
TYPE
  BuffType = ARRAY[1..buffsize] OF Char;
VAR
  FilVar   : FILE;
  Filename : STRING[64];
  Actual   : Integer;
  MinLen   : Byte;
  buffer   : BuffType;
  ASCII    : ARRAY[Char] OF Boolean;  
  overlap  : Byte;

  PROCEDURE Check(VAR B : BuffType; top : Integer; VAR OvLap : Byte);
  VAR P, Pend, i : Integer;
  BEGIN
    P := 1;
    OvLap := 0;
    REPEAT
      IF ASCII[B[P]] THEN
        BEGIN
          Pend := P;
          REPEAT
            Pend := Succ(Pend)
          UNTIL (NOT ASCII[B[Pend]]) OR (Pend = top);
          IF ((Pend = top) AND ASCII[B[Pend]]) THEN
            OvLap := Succ(Pend-P)
          ELSE
            IF Succ(Pend-P) >= MinLen THEN
              BEGIN
                FOR i := P TO Pred(Pend) DO Write(B[i]);
                WriteLn;
              END;
          P := Succ(Pend);
        END
      ELSE P := Succ(P);
    UNTIL (P >= top);
  END;


BEGIN
  FillChar(ASCII, SizeOf(ASCII), False);
  FillChar(ASCII[#32], 96, True);
  (* Now for any character CH, ASCII[CH] is true *)
  (* only if CH is a charcter from #32 to #127   *)
  Write('Enter minimum string length to check for : ');
  ReadLn(MinLen);
  Write('Enter name of file to check: ');
  ReadLn(Filename);
  Assign(FilVar, Filename);
  Reset(FilVar, 1);
  WHILE NOT EoF(FilVar) DO
    BEGIN
      BlockRead(FilVar, buffer, buffsize, Actual);
      Check(buffer, Actual, overlap);
      {Back up to get any that "cross" into the next buffer}
      IF (Actual = buffsize) AND (overlap > 0) THEN
        Seek(FilVar, FilePos(FilVar)-overlap);
(* NOTE:  This is a Turbo Pascal 4.0 program, but you can 
   convert it for TP3 by deleting out the line above
   and replacing it with the line below. *)
       (* LongSeek(FilVar, LongFilePos(FilVar)-overlap); *)
    END;
  Close(FilVar);
END.